/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sub/supplier"})
public class SubSupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer BILL_TYPE = 2;
    @Autowired
    private ISuplSupplierService supplierService;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IBillTypeService billTypeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if (supplierVo.getCategoryId() == null) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse<SupplierVO> response = this.supplierService.saveOrUpdate(supplierVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
        SupplierVO supplierVo = this.supplierService.queryDetail(id);
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.categoryService.selectById(supplierVo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        supplierVo.setParent(parent);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
            for (Long id : ids) {
                CommonResponse<String> response = this.billTypeService.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam, BILL_TYPE);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }
}

