package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// 物资
@RestController
@RequestMapping("wz/supplier")
public class WzSupplierController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer BILL_TYPE = 1;

    @Autowired
    private ISuplSupplierService supplierService;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IBillTypeService billTypeService;

    /**
     * 新增或者修改
     *
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if(supplierVo.getCategoryId() == null){
            return CommonResponse.error("供方分类不能为空！");
        }
        CommonResponse<SupplierVO> response = supplierService.saveOrUpdate(supplierVo);
        return response;
    }
    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
        SupplierVO supplierVo = supplierService.queryDetail(id);
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = categoryService.selectById(supplierVo.getCategoryId());
        parent.put("id",e.getId());
        parent.put("code",e.getCode());
        parent.put("name",e.getName());
        supplierVo.setParent(parent);
        return CommonResponse.success(supplierVo);
    }
    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            bankAccountService.delBySuppAndCustomIds("supplierId",ids);
            for (Long id : ids) {
                CommonResponse<String>  response = billTypeService.checkQuote("BT200422000000028",id);
                if(!response.isSuccess()){
                    return CommonResponse.error("删除失败："+response.getMsg());
                }
            }
        }else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        supplierService.deleteSupplier(ids);
        return CommonResponse.success("删除成功");
    }
    /**
     * 查询供方分页列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<SupplierVO> pageData = supplierService.queryPageList(queryParam,BILL_TYPE);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success(jsonObject);
    }
    /**
     * 外部供方列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "/refSupplierPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue = "1") int pageNumber,
                                                             @RequestParam(defaultValue = "10") int pageSize,
                                                             @RequestParam(required=false) String relyCondition,
                                                             @RequestParam(required=false) String searchText,
                                                             @RequestParam(required=false) String condition
    ) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("socialCreditCode");
        queryParam.getFuzzyFields().add("legal");
        if(StringUtils.isNotBlank(relyCondition)){
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            SupplierCategoryEntity supplierCategoryEntity = categoryService.queryDetail(categoryId);
            if(supplierCategoryEntity != null) {
                queryParam.getParams().put("categoryId", new Parameter(QueryParam.EQ,categoryId));
            }
        }
        queryParam.getParams().put("insideOrgId", new Parameter(QueryParam.EQ,null));
        IPage<SupplierVO> pageData = supplierService.queryPageList(queryParam,BILL_TYPE);
        return CommonResponse.success("参照查询成功！", pageData);
    }
    /**
     * 内部供方列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "/refInsideSupplierPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refInsideSupplierPage(@RequestParam(defaultValue = "1") int pageNumber,
                                                                   @RequestParam(defaultValue = "10") int pageSize,
                                                                   @RequestParam(required=false) String relyCondition,
                                                                   @RequestParam(required=false) String searchText,
                                                                   @RequestParam(required=false) String condition
    ) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("socialCreditCode");
        queryParam.getFuzzyFields().add("legal");
        if(StringUtils.isNotBlank(relyCondition)){
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            SupplierCategoryEntity supplierCategoryEntity = categoryService.queryDetail(categoryId);
            if(supplierCategoryEntity != null) {
                queryParam.getParams().put("categoryId", new Parameter(QueryParam.EQ,categoryId));
            }
        }
        queryParam.getParams().put("insideOrgId", new Parameter(QueryParam.NE,null));
        IPage<SupplierVO> pageData = supplierService.queryPageList(queryParam,BILL_TYPE);
        return CommonResponse.success("参照查询成功！", pageData);
    }

}
