package com.ejianc.foundation.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.supplier.mapper.SuplCategoryMapper;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class SuplCategoryServiceImpl extends BaseServiceImpl<SuplCategoryMapper, SupplierCategoryEntity> implements ISuplCategoryService {

    private static final String SUPPLIER_CATEGORY_BILL_CODE = "SUPPORT_SUPPLIER_CATEGORY";
    @Autowired
    private IBillCodeGenerator generator;

    @Override
    public void saveOrUpdate(SupplierCategoryVO supplierCategoryVo, Integer billType) throws BillCodeException {
        supplierCategoryVo.setBillType(billType);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (supplierCategoryVo.getId() != null && supplierCategoryVo.getId() > 0) {
            SupplierCategoryEntity uniqueBean = baseMapper.selectById(supplierCategoryVo.getId());
            uniqueBean.setCode(supplierCategoryVo.getCode());
            uniqueBean.setName(supplierCategoryVo.getName());
            uniqueBean.setSequence(supplierCategoryVo.getSequence());
            uniqueBean.setDescription(supplierCategoryVo.getDescription());
            super.saveOrUpdate(uniqueBean, false);
        } else {
            String billCode = generator.generateBillCodeById(SUPPLIER_CATEGORY_BILL_CODE, tenantId);
            supplierCategoryVo.setCode(billCode);
            SupplierCategoryEntity supplierCategoryEntity = BeanMapper.map(supplierCategoryVo, SupplierCategoryEntity.class);
            supplierCategoryEntity.setId(IdWorker.getId());
            if (supplierCategoryEntity.getParentId() != null && supplierCategoryEntity.getParentId() > 0) {
                SupplierCategoryEntity uniqueBean = baseMapper.selectById(supplierCategoryEntity.getParentId());
                supplierCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + supplierCategoryEntity.getId());
            } else {
                supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
            }
            super.saveOrUpdate(supplierCategoryEntity, false);
        }
    }

    @Override
    public SupplierCategoryEntity queryDetail(Long id) {
        SupplierCategoryEntity entity = baseMapper.selectById(id);
        return entity;
    }

    @Override
    public List<SupplierCategoryVO> queryListByPid(Long id) {
        QueryWrapper<SupplierCategoryEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("parent_id", id);
        List<SupplierCategoryEntity> entities = baseMapper.selectList(wrapper);
        if (entities != null) {
            return BeanMapper.mapList(entities, SupplierCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        baseMapper.deleteById(id);
    }

    @Override
    public List<SupplierCategoryEntity> treeList(QueryParam queryParam, String code, Integer billType) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("billType", new Parameter(QueryParam.EQ, billType));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("code", new Parameter(QueryParam.EQ, code));
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);
        queryParam.getOrderMap().put("sequence", "asc");
        List<SupplierCategoryEntity> dataList = super.queryList(queryParam, false);
        return dataList;
    }

    @Override
    public List<Map<String, Object>> querySupplierRefTree(String searchText,String code, Integer billType) {
        //外部供应商
        try {
            QueryParam queryParam = new QueryParam();
            if(StringUtils.isNotBlank(searchText)) {
                queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
            }
            queryParam.getParams().put("code", new Parameter(QueryParam.NE, code));
            queryParam.getParams().put("billType", new Parameter(QueryParam.EQ, billType));
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("sequence", "asc");
            List<SupplierCategoryEntity> dataList = super.queryList(queryParam, false);

            List<Map> resultMapList = new ArrayList<Map>();
            Map map = null;
            for(SupplierCategoryEntity entity: dataList) {
                map = new HashMap<>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getName());
                map.put("title", entity.getName());
                map.put("parentId", entity.getParentId());
                resultMapList.add(map);
            }
            List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
            return result;
        } catch (Exception e) {
            return null;
        }
    }
}
