/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/module/"})
public class ModuleController
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    private static final long serialVersionUID = 1L;
    private static final String MODULE_BILL_CODE = "SUPPORT_MODULE";
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IBillCodeGenerator generator;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ModuleVO moduleVo) throws BillCodeException {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (moduleVo.getId() != null && moduleVo.getId() > 0L) {
            ModuleEntity uniqueBean = this.moduleService.queryDetail(moduleVo.getId());
            uniqueBean.setModuleCode(moduleVo.getModuleCode());
            uniqueBean.setModuleName(moduleVo.getModuleName());
            uniqueBean.setSequence(moduleVo.getSequence());
            uniqueBean.setDescription(moduleVo.getDescription());
            this.moduleService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        String billCode = this.generator.generateBillCodeById(MODULE_BILL_CODE, tenantId);
        moduleVo.setModuleCode(billCode);
        ModuleEntity moduleEntity = (ModuleEntity)((Object)BeanMapper.map((Object)moduleVo, ModuleEntity.class));
        moduleEntity.setId(IdWorker.getId());
        if (moduleEntity.getParentId() != null && moduleEntity.getParentId() > 0L) {
            ModuleEntity uniqueBean = this.moduleService.queryDetail(moduleEntity.getParentId());
            moduleEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + moduleEntity.getId());
        } else {
            moduleEntity.setInnerCode(moduleEntity.getId().toString());
        }
        this.moduleService.saveOrUpdate((Object)moduleEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List dataList = this.moduleService.queryList(queryParam, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ModuleVO> queryDetail(@RequestParam Long id) {
        ModuleEntity entity = this.moduleService.queryDetail(id);
        if (entity != null) {
            ModuleVO moduleVo = (ModuleVO)BeanMapper.map((Object)((Object)entity), ModuleVO.class);
            return CommonResponse.success((Object)moduleVo);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u4e0d\u6b63\u786e");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<ModuleEntity> moduleDetails = this.moduleService.queryListByPid(id);
        if (moduleDetails != null && moduleDetails.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u6a21\u5757\u4e0b\u6709\u5b50\u8282\u70b9\u4e86\uff0c \u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.moduleService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/loadModuleTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> loadReferModuleTree() {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List dataList = this.moduleService.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ModuleEntity entity : dataList) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("title", entity.getModuleName());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        List result = ResultAsTree.createTreeData(resultMapList);
        return CommonResponse.success((Object)result);
    }

    @GetMapping(value={"/allModuleTreeRefer"})
    public List<Map<String, Object>> moduleTreeRefer() {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List dataList = this.moduleService.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ModuleEntity entity : dataList) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getModuleName());
            map.put("code", entity.getModuleCode());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        List result = ResultAsTree.createTreeData(resultMapList);
        return result;
    }

    @RequestMapping(value={"/referTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize) {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List dataList = this.moduleService.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ModuleEntity entity : dataList) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getModuleName());
            map.put("code", entity.getModuleCode());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ModuleEntity entity = this.moduleService.queryDetail(publishVO.getModuleId());
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(entity);
            List<String> insertSql = this.getInsertSql(entity);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("sql", sqls);
            String paramterStr = this.gson.toJson(params);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
    }

    private List<String> getDeleteSql(ModuleEntity entity) {
        if (entity == null) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        idStr = "(" + entity.getId() + ")";
        String baseTableName = "ejc_support_module";
        String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
        sqlList.add(deleteBaseSql);
        return sqlList;
    }

    private List<String> getInsertSql(ModuleEntity entity) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        ArrayList<ModuleEntity> baseEntityList = new ArrayList<ModuleEntity>();
        baseEntityList.add(entity);
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        return retList;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            ModuleEntity entity = this.moduleService.queryDetail(publishVO.getModuleId());
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(entity);
            List<String> insertSql = this.getInsertSql(entity);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("module.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

