/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.bean.HistoricalPerformanceEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.service.IHistoricalPerformanceService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.vo.HistoricalPerformanceVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.mapper.SuplSupplierMapper;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SuplSupplierServiceImpl
extends BaseServiceImpl<SuplSupplierMapper, SupplierEntity>
implements ISuplSupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private IHistoricalPerformanceService historicalPerformanceService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<SupplierVO> queryListByCategoryId(Long categoryId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category_id", (Object)categoryId);
        List entities = ((SuplSupplierMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, SupplierVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplierEntity entity = null;
        String operateType = null;
        this.check(supplierVo);
        if (supplierVo.getId() == null || supplierVo.getId() <= 0L) {
            throw new BusinessException("\u6682\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVo, SupplierEntity.class));
        operateType = "edit";
        if (StringUtils.isNotBlank((CharSequence)entity.getArea())) {
            String regex = "((?<provinceAndCity>[^\u5e02]+\u5e02|.*?\u81ea\u6cbb\u5dde|.*?\u533a|.*\u53bf)(?<town>[^\u533a]+\u533a|.*?\u5e02|.*?\u53bf|.*?\u8def|.*?\u8857|.*?\u9053|.*?\u9547|.*?\u65d7)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
            while (matcher.find()) {
                try {
                    entity.setRegion(matcher.group("town"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String regex2 = "((?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|\u4e0a\u6d77\u5e02|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u91cd\u5e86\u5e02|\u4e0a\u6d77|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86|\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a)(?<city>.*))";
                Object provinceAndCity = "";
                try {
                    provinceAndCity = matcher.group("provinceAndCity");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Matcher matcher2 = Pattern.compile(regex2).matcher((CharSequence)provinceAndCity);
                while (matcher2.find()) {
                    try {
                        entity.setProvince(matcher.group("province"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        String city = matcher2.group("city");
                        if (StringUtils.isBlank((CharSequence)city)) {
                            entity.setCity(entity.getProvince());
                            continue;
                        }
                        entity.setCity(matcher.group("city"));
                    }
                    catch (IllegalArgumentException city) {}
                }
            }
        }
        super.saveOrUpdate((Object)entity);
        List supplierLinkerVos = supplierVo.getGridheaders();
        ArrayList<SupplierLinkerEntity> saveOrUpldates = new ArrayList<SupplierLinkerEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (SupplierLinkerVO supplierLinkerVo : supplierLinkerVos) {
            SupplierLinkerEntity supplierLinkerEntity;
            if ("add".equals(supplierLinkerVo.getRowState())) {
                supplierLinkerEntity = (SupplierLinkerEntity)((Object)BeanMapper.map((Object)supplierLinkerVo, SupplierLinkerEntity.class));
                supplierLinkerEntity.setSupplierId(entity.getId());
                saveOrUpldates.add(supplierLinkerEntity);
                continue;
            }
            if ("edit".equals(supplierLinkerVo.getRowState())) {
                supplierLinkerEntity = (SupplierLinkerEntity)((Object)BeanMapper.map((Object)supplierLinkerVo, SupplierLinkerEntity.class));
                saveOrUpldates.add(supplierLinkerEntity);
                continue;
            }
            if (!"del".equals(supplierLinkerVo.getRowState())) continue;
            deleteIds.add(supplierLinkerVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.supplierLinkerService.removeByIds(deleteIds, false);
        }
        List performanceVos = supplierVo.getPerformanceVos();
        ArrayList<HistoricalPerformanceEntity> saves = new ArrayList<HistoricalPerformanceEntity>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (HistoricalPerformanceVO vo : performanceVos) {
            HistoricalPerformanceEntity performanceEntity;
            if ("add".equals(vo.getRowState())) {
                performanceEntity = (HistoricalPerformanceEntity)((Object)BeanMapper.map((Object)vo, HistoricalPerformanceEntity.class));
                performanceEntity.setSupplierId(entity.getId());
                saves.add(performanceEntity);
                continue;
            }
            if ("edit".equals(vo.getRowState())) {
                performanceEntity = (HistoricalPerformanceEntity)((Object)BeanMapper.map((Object)vo, HistoricalPerformanceEntity.class));
                saves.add(performanceEntity);
                continue;
            }
            if (!"del".equals(vo.getRowState())) continue;
            delIds.add(vo.getId());
        }
        if (saves.size() > 0) {
            this.historicalPerformanceService.saveOrUpdateBatch(saves, saves.size(), false);
        }
        if (delIds.size() > 0) {
            this.historicalPerformanceService.removeByIds(delIds, false);
        }
        SupplierVO vo = this.queryDetail(entity.getId());
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.categoryService.selectById(vo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        vo.setParent(parent);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public SupplierVO queryDetail(Long id) {
        SupplierEntity entity = (SupplierEntity)((Object)((SuplSupplierMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            List historicalPerformanceEntities;
            SupplierVO supplierVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List supplierLinkers = this.supplierLinkerService.queryList(queryParam, false);
            if (supplierLinkers != null && supplierLinkers.size() > 0) {
                List supplierLinkerVos = BeanMapper.mapList((Iterable)supplierLinkers, SupplierLinkerVO.class);
                supplierVo.setGridheaders(supplierLinkerVos);
            }
            if ((historicalPerformanceEntities = this.historicalPerformanceService.queryList(queryParam, false)) != null && historicalPerformanceEntities.size() > 0) {
                List vos = BeanMapper.mapList((Iterable)historicalPerformanceEntities, HistoricalPerformanceVO.class);
                supplierVo.setPerformanceVos(vos);
            }
            return supplierVo;
        }
        return null;
    }

    @Override
    public void deleteSupplier(List<Long> ids) {
        for (Long id : ids) {
            this.supplierLinkerService.deleteBySupplierId(id);
            this.historicalPerformanceService.deleteBySupplierId(id);
            ((SuplSupplierMapper)this.baseMapper).deleteById(id);
        }
    }

    @Override
    public IPage<SupplierVO> queryPageList(QueryParam queryParam, Integer billType) {
        Map paramMap = queryParam.getParams();
        if (paramMap.get("categoryId") != null) {
            if (StringUtils.isNotBlank((CharSequence)((Parameter)paramMap.get("categoryId")).getValue().toString())) {
                SupplierCategoryEntity categoryEntity = this.categoryService.queryDetail(Long.parseLong(((Parameter)paramMap.get("categoryId")).getValue().toString()));
                if (categoryEntity != null) {
                    LambdaQueryWrapper lambd = new LambdaQueryWrapper();
                    lambd.like(SupplierCategoryEntity::getInnerCode, (Object)categoryEntity.getInnerCode());
                    List list = this.categoryService.list((Wrapper)lambd);
                    List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    queryParam.getParams().remove("categoryId");
                    queryParam.getParams().put("categoryId", new Parameter("in", ids));
                }
            } else {
                queryParam.getParams().remove("categoryId");
            }
        }
        if (billType == 1) {
            queryParam.getParams().put("supplierFlag", new Parameter("eq", (Object)1));
        }
        if (billType == 2) {
            queryParam.getParams().put("subFlag", new Parameter("eq", (Object)1));
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = super.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return pageData;
    }

    @Override
    public void sysSupplier(SuplSupplierVO supplierVo) {
        List hises;
        Integer subFlag;
        Integer supplierFlag = supplierVo.getSupplierFlag() == null ? 0 : supplierVo.getSupplierFlag();
        if (supplierFlag == (subFlag = Integer.valueOf(supplierVo.getSubFlag() == null ? 0 : supplierVo.getSubFlag()))) {
            this.logger.info("\u540c\u65f6\u5c5e\u4e8e\u7269\u8d44\u6216\u5206\u5305");
            throw new BusinessException("\u540c\u6b65\u5931\u8d25");
        }
        List linkerList = supplierVo.getLinkerList();
        List historicalPerformanceList = supplierVo.getHistoricalPerformanceList();
        List bankAccountList = supplierVo.getBankAccountList();
        this.logger.info("\u540c\u6b65\u4f9b\u5e94\u5546");
        long id = IdWorker.getId();
        SupplierEntity entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVo, SupplierEntity.class));
        entity.setBlacklistFlag(0);
        entity.setRedlistFlag(0);
        entity.setCreateTime(new Date());
        entity.setAccessId(entity.getId());
        entity.setId(id);
        entity.setCode(supplierVo.getBillCode());
        super.saveOrUpdate((Object)entity);
        this.logger.info("\u540c\u6b65\u8054\u7cfb\u4eba");
        if (linkerList != null && linkerList.size() > 0) {
            List links = BeanMapper.mapList((Iterable)linkerList, SupplierLinkerEntity.class);
            for (SupplierLinkerEntity link : links) {
                link.setId(null);
                link.setSupplierId(id);
            }
            this.supplierLinkerService.saveOrUpdateBatch(links, links.size(), false);
        }
        this.logger.info("\u540c\u6b65\u4f01\u4e1a\u5386\u53f2\u4e1a\u7ee9");
        if (historicalPerformanceList != null && historicalPerformanceList.size() > 0) {
            hises = BeanMapper.mapList((Iterable)historicalPerformanceList, HistoricalPerformanceEntity.class);
            for (BaseEntity his : hises) {
                his.setId(null);
                his.setSupplierId(id);
            }
            this.historicalPerformanceService.saveOrUpdateBatch(hises, hises.size(), false);
        }
        this.logger.info("\u540c\u6b65\u94f6\u884c\u8d26\u6237");
        if (bankAccountList != null && bankAccountList.size() > 0) {
            hises = BeanMapper.mapList((Iterable)bankAccountList, BankAccountEntity.class);
            for (BaseEntity his : hises) {
                his.setId(null);
                his.setSupplierId(id);
                his.setSupplierName(entity.getName());
            }
            this.bankAccountService.saveOrUpdateBatch(hises, hises.size(), false);
        }
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierVo.getId()), "BT211103000000001", null, String.valueOf(id), "BT200422000000028", null);
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u6765\u6e90id::" + supplierVo.getId());
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u76ee\u6807id::" + id);
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + response.toString());
    }

    @Override
    public List<SupplierVO> excelExport(QueryParam queryParam, Integer billType) {
        Map paramMap = queryParam.getParams();
        if (paramMap.get("categoryId") != null) {
            if (StringUtils.isNotBlank((CharSequence)((Parameter)paramMap.get("categoryId")).getValue().toString())) {
                SupplierCategoryEntity categoryEntity = this.categoryService.queryDetail(Long.parseLong(((Parameter)paramMap.get("categoryId")).getValue().toString()));
                if (categoryEntity != null) {
                    LambdaQueryWrapper lambd = new LambdaQueryWrapper();
                    lambd.like(SupplierCategoryEntity::getInnerCode, (Object)categoryEntity.getInnerCode());
                    List list = this.categoryService.list((Wrapper)lambd);
                    List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    queryParam.getParams().remove("categoryId");
                    queryParam.getParams().put("categoryId", new Parameter("in", ids));
                }
            } else {
                queryParam.getParams().remove("categoryId");
            }
        }
        if (billType == 1) {
            queryParam.getParams().put("supplierFlag", new Parameter("eq", (Object)1));
        }
        if (billType == 2) {
            queryParam.getParams().put("subFlag", new Parameter("eq", (Object)1));
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = super.queryList(queryParam, false);
        List vos = BeanMapper.mapList((Iterable)list, SupplierVO.class);
        for (SupplierVO supplierVo : vos) {
            DefdocDetailVO taxPayerTypeVo = this.defdocDetailService.queryDetail(supplierVo.getEnterpriseNature());
            if (taxPayerTypeVo != null) {
                supplierVo.setEnterpriseNatureName(taxPayerTypeVo.getName());
            }
            if (supplierVo.getEvaluationGrade() != null) {
                if (supplierVo.getEvaluationGrade() == 0) {
                    supplierVo.setEvaluationGradeName("\u4e0d\u5408\u683c");
                }
                if (supplierVo.getEvaluationGrade() == 1) {
                    supplierVo.setEvaluationGradeName("\u5408\u683c");
                }
            }
            QueryParam linkerQueryParam = new QueryParam();
            linkerQueryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierVo.getId()));
            linkerQueryParam.getParams().put("defaultFlag", new Parameter("eq", (Object)1));
            List linkerEntities = this.supplierLinkerService.queryList(linkerQueryParam, false);
            if (linkerEntities == null || linkerEntities.size() <= 0) continue;
            SupplierLinkerEntity linkerEntity = (SupplierLinkerEntity)((Object)linkerEntities.get(0));
            supplierVo.setLinkman(linkerEntity.getLinkman());
            supplierVo.setCellphone(linkerEntity.getCellphone());
        }
        return vos;
    }

    @Override
    public void saveBlackList(List<Long> ids) {
        Long operateId = this.sessionManager.getUserContext().getUserId();
        String operateName = this.sessionManager.getUserContext().getUserName();
        Long operateOrgId = this.sessionManager.getUserContext().getOrgId();
        String operateOrgName = this.sessionManager.getUserContext().getOrgName();
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(SupplierEntity::getOperateId, (Object)operateId);
        lambd.set(SupplierEntity::getOperateName, (Object)operateName);
        lambd.set(SupplierEntity::getOperateTime, (Object)new Date());
        lambd.set(SupplierEntity::getOperateOrgId, (Object)operateOrgId);
        lambd.set(SupplierEntity::getOperateOrgName, (Object)operateOrgName);
        lambd.set(SupplierEntity::getBlacklistFlag, (Object)1);
        lambd.in(BaseEntity::getId, ids);
        super.update((Wrapper)lambd);
    }

    private void check(SupplierVO supplierVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (supplierVo.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)supplierVo.getId());
        }
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"social_credit_code", (Object)supplierVo.getSocialCreditCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\uff01\uff01\uff01");
        }
    }
}

