/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialMapper;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MaterialServiceImpl
implements IMaterialService {
    @Autowired
    private MaterialMapper materialMapper;
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;

    @Override
    public List<MaterialVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> entities = this.materialMapper.queryListByCategoryId(tenantId, categoryId);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, MaterialVO.class);
        }
        return null;
    }

    @Override
    public MaterialVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialEntity entity = this.materialMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (MaterialVO)BeanMapper.map((Object)entity, MaterialVO.class);
        }
        return null;
    }

    @Override
    public void update(MaterialVO uniqueBean) {
        this.materialMapper.update(uniqueBean);
    }

    @Override
    public void save(MaterialVO materialVo) {
        this.materialMapper.save(materialVo);
    }

    @Override
    public void insertBatch(List<MaterialVO> materialVOList) {
        if (ListUtil.isNotEmpty(materialVOList)) {
            ArrayList<Object> toInsert = new ArrayList<MaterialVO>();
            for (MaterialVO materialVO : materialVOList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(materialVO);
            }
            if (toInsert.size() > 0) {
                this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void amend(Long id, Long property, String propertyName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.amend(id, property, propertyName, tenantId);
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                MaterialCategoryEntity categoryEntity;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<MaterialEntity> records = this.materialMapper.queryList(condition);
        Long count = this.materialMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialVO materialVo = this.materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return materialVo;
    }

    @Override
    public List<MaterialVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialVO> list = this.materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
        return list;
    }

    @Override
    public MaterialVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<MaterialEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<MaterialEntity> records = this.materialMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertMaterialListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.insertMaterialListFromPlatform(tenantId);
    }

    @Override
    public IPage<MaterialEntity> queryRefMaterialPage(Map<String, Object> params) {
        List<MaterialEntity> dataList = this.materialMapper.queryRefMaterialList(params);
        Long dataCount = this.materialMapper.queryRefMaterialCount(params);
        Page page = new Page();
        page.setRecords(dataList);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public MaterialEntity queryBySourceId(String sourceId) {
        return this.materialMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
        return this.materialMapper.queryMaterialByIds(ids, InvocationInfoProxy.getTenantid());
    }

    @Override
    public IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
        Page page = new Page();
        if (params.containsKey("sourceOrgId") && null != params.get("sourceOrgId")) {
            List<MaterialEntity> dataList = this.materialMapper.queryZjwjRefMaterialList(params);
            Long dataCount = this.materialMapper.queryZjwjRefMaterialCount(params);
            page.setRecords(dataList);
            page.setTotal(dataCount.longValue());
        }
        return page;
    }
}

