/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billParam"})
public class BillParamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillParamService service;
    @Value(value="${oms.tenantid}")
    private Long omsTenantId;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillParamCustomService billParamCustomService;
    @Autowired
    private IDefdocDetailService defdocDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillParamVO> saveOrUpdate(@RequestBody BillParamVO billParamVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (billParamVO.getId() == null) {
            if (!this.omsTenantId.equals(tenantId)) {
                throw new BusinessException("\u60a8\u6ca1\u6709\u65b0\u589e\u5355\u636e\u53c2\u6570\u7684\u6743\u9650");
            }
            String billCode = "";
            try {
                CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode("param-register-001", InvocationInfoProxy.getTenantid());
                if (!codeResp.isSuccess()) {
                    throw new BusinessException("\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\uff1a" + codeResp.getMsg());
                }
                billCode = (String)codeResp.getData();
            }
            catch (Exception e) {
                throw new BusinessException("\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25", (Throwable)e);
            }
            billParamVO.setCode(billCode);
        }
        if (this.omsTenantId.equals(tenantId)) {
            BillParamEntity entity = (BillParamEntity)((Object)BeanMapper.map((Object)billParamVO, BillParamEntity.class));
            this.service.saveOrUpdate((Object)entity, false);
            BillParamVO vo = (BillParamVO)BeanMapper.map((Object)((Object)entity), BillParamVO.class);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("pid", new Parameter("eq", (Object)billParamVO.getId()));
        List customEntities = this.billParamCustomService.queryList(param, false);
        BillParamCustomEntity customEntity = null;
        customEntity = ListUtil.isEmpty((List)customEntities) ? new BillParamCustomEntity() : (BillParamCustomEntity)((Object)customEntities.get(0));
        customEntity.setControlType(billParamVO.getControlType());
        customEntity.setTenantId(tenantId);
        customEntity.setRoleValue(billParamVO.getRoleValue());
        customEntity.setPid(billParamVO.getId());
        this.billParamCustomService.saveOrUpdate((Object)customEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)billParamVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillParamVO> queryDetail(Long id) {
        DefdocDetailVO defdocDetailVo;
        BillParamEntity entity = (BillParamEntity)((Object)this.service.selectById(id));
        BillParamVO vo = (BillParamVO)BeanMapper.map((Object)((Object)entity), BillParamVO.class);
        if (!this.omsTenantId.equals(InvocationInfoProxy.getTenantid())) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("pid", new Parameter("eq", (Object)id));
            List customEntities = this.billParamCustomService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)customEntities)) {
                BillParamCustomEntity e = (BillParamCustomEntity)((Object)customEntities.get(0));
                vo.setControlType(e.getControlType());
                vo.setRoleValue(e.getRoleValue());
            } else {
                BillParamCustomEntity customEntity = new BillParamCustomEntity();
                customEntity.setControlType(vo.getControlType());
                customEntity.setTenantId(InvocationInfoProxy.getTenantid());
                customEntity.setRoleValue(vo.getRoleValue());
                customEntity.setPid(id);
                this.billParamCustomService.saveOrUpdate((Object)customEntity, false);
            }
        }
        if ((defdocDetailVo = this.defdocDetailService.queryDetail(Long.parseLong(entity.getModuleId()))) == null) {
            defdocDetailVo = this.defdocDetailService.queryDetailOMS_TENANT(Long.parseLong(entity.getModuleId()));
        }
        if (defdocDetailVo == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u53c2\u6570\u5206\u7c7b\uff01");
        }
        vo.setModuleName(defdocDetailVo.getName());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillParamVO> vos) {
        if (!this.omsTenantId.equals(InvocationInfoProxy.getTenantid())) {
            throw new BusinessException("\u60a8\u6ca1\u6709\u5220\u9664\u7684\u6743\u9650");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        List customEntities = this.billParamCustomService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)customEntities)) {
            this.billParamCustomService.removeByIds(customEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillParamVO>> queryList(@RequestBody QueryParam param) {
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), BillParamVO.class);
        if (!this.omsTenantId.equals(InvocationInfoProxy.getTenantid()) && ListUtil.isNotEmpty((List)records)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            records.forEach(vo -> {
                queryParam.getParams().put("pid", new Parameter("eq", (Object)vo.getId()));
                List customEntities = this.billParamCustomService.queryList(queryParam, false);
                if (ListUtil.isNotEmpty((List)customEntities)) {
                    BillParamCustomEntity e = (BillParamCustomEntity)((Object)((Object)customEntities.get(0)));
                    vo.setControlType(e.getControlType());
                    vo.setRoleValue(e.getRoleValue());
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/publishParamConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> publishParamConfig(@RequestBody PublishVO publishVO) {
        return this.service.publishParamConfig(publishVO);
    }
}

