package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.vo.BillParamVO;

/**
 * 业务单据控制参数
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("billParam")
public class BillParamController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBillParamService service;

    @Value("${oms.tenantid}")
    private Long omsTenantId;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBillParamCustomService billParamCustomService;

    @Autowired
    private IDefdocDetailService defdocDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillParamVO> saveOrUpdate(@RequestBody BillParamVO billParamVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(billParamVO.getId()==null){
            /** 新增 */
            if(!omsTenantId.equals(tenantId)) {
                throw new BusinessException("您没有新增单据参数的权限");
            }
            String billCode = "";
            try {
                CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode("param-register-001", InvocationInfoProxy.getTenantid());
                if(!codeResp.isSuccess()) {
                    throw new BusinessException("生成单据编码失败：" + codeResp.getMsg());
                }
                billCode = codeResp.getData();
            } catch (Exception e) {
                throw new BusinessException("生成单据编码失败", e);
            }
            billParamVO.setCode(billCode);
        }
        if(omsTenantId.equals(tenantId)) {
            BillParamEntity entity = BeanMapper.map(billParamVO, BillParamEntity.class);
            service.saveOrUpdate(entity, false);
            BillParamVO vo = BeanMapper.map(entity, BillParamVO.class);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }
        /**普通租户*/
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
        param.getParams().put("pid",new Parameter(QueryParam.EQ,billParamVO.getId()));
        List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
        BillParamCustomEntity customEntity = null;
        if(ListUtil.isEmpty(customEntities)){
            customEntity = new BillParamCustomEntity();
        }else {
            customEntity = customEntities.get(0);
        }
        customEntity.setControlType(billParamVO.getControlType());
        customEntity.setTenantId(tenantId);
        customEntity.setRoleValue(billParamVO.getRoleValue());
        customEntity.setPid(billParamVO.getId());
        billParamCustomService.saveOrUpdate(customEntity,false);
    	return CommonResponse.success("保存或修改单据成功！",billParamVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillParamVO> queryDetail(Long id) {
    	BillParamEntity entity = service.selectById(id);
    	BillParamVO vo = BeanMapper.map(entity, BillParamVO.class);
        if(!omsTenantId.equals(InvocationInfoProxy.getTenantid())) {
            /**普通租户*/
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
            param.getParams().put("pid",new Parameter(QueryParam.EQ,id));
            List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
            if(ListUtil.isNotEmpty(customEntities)){
                BillParamCustomEntity e = customEntities.get(0);
                vo.setControlType(e.getControlType());
                vo.setRoleValue(e.getRoleValue());
            }else {
                BillParamCustomEntity customEntity = new BillParamCustomEntity();
                customEntity.setControlType(vo.getControlType());
                customEntity.setTenantId(InvocationInfoProxy.getTenantid());
                customEntity.setRoleValue(vo.getRoleValue());
                customEntity.setPid(id);
                billParamCustomService.saveOrUpdate(customEntity,false);
            }
        }
        DefdocDetailVO defdocDetailVo = defdocDetailService.queryDetail(Long.parseLong(entity.getModuleId()));
        if(defdocDetailVo == null){
            defdocDetailVo = defdocDetailService.queryDetailOMS_TENANT(Long.parseLong(entity.getModuleId()));
        }
        if(defdocDetailVo == null){
            return CommonResponse.error("没有查到参数分类！");
        }
        vo.setModuleName(defdocDetailVo.getName());
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillParamVO> vos) {
        if(!omsTenantId.equals(InvocationInfoProxy.getTenantid())) {
            throw new BusinessException("您没有删除的权限");
        }
        service.removeByIds(vos.stream().map(BillParamVO::getId).collect(Collectors.toList()),true);
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.IN,vos.stream().map(BillParamVO::getId).collect(Collectors.toList())));
        List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
        if(ListUtil.isNotEmpty(customEntities)){
            billParamCustomService.removeByIds(customEntities.stream().map(BillParamCustomEntity::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillParamVO>> queryList(@RequestBody QueryParam param) {

        IPage<BillParamEntity> page = service.queryPage(param,false);
        IPage<BillParamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BillParamVO> records = BeanMapper.mapList(page.getRecords(), BillParamVO.class);
        if(!omsTenantId.equals(InvocationInfoProxy.getTenantid()) && ListUtil.isNotEmpty(records)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
            records.forEach(vo->{
                queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,vo.getId()));
                List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(queryParam,false);
                if(ListUtil.isNotEmpty(customEntities)){
                    BillParamCustomEntity e = customEntities.get(0);
                    vo.setControlType(e.getControlType());
                    vo.setRoleValue(e.getRoleValue());
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/1/15 发布参数
     * @Description publishParamConfig
     * @Param [publishVO]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     */
    @RequestMapping(value = "/publishParamConfig", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> publishParamConfig(@RequestBody PublishVO publishVO){
        return service.publishParamConfig(publishVO);
    }
}
