package com.ejianc.foundation.support.controller;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;

/**
 * 模块管理控制器
 */
@SuppressWarnings({"rawtypes","unchecked"})
@RestController
@RequestMapping("/module/")
public class ModuleController implements Serializable {
	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	private Gson gson = new Gson();
	private static final long serialVersionUID = 1L;
	private static final String MODULE_BILL_CODE = "SUPPORT_MODULE";
	
	@Autowired
    private IModuleService moduleService;
	@Autowired
	private IBillCodeGenerator generator;
    /**
     * 新增或者修改
     * 
     * @param moduleVo
     * @return
     * @throws BillCodeException 
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ModuleVO moduleVo) throws BillCodeException {
    	Long tenantId = InvocationInfoProxy.getTenantid();
    	if(moduleVo.getId() != null && moduleVo.getId() > 0) {
    		ModuleEntity uniqueBean = moduleService.queryDetail(moduleVo.getId());
    		uniqueBean.setModuleCode(moduleVo.getModuleCode());
    		uniqueBean.setModuleName(moduleVo.getModuleName());
    		uniqueBean.setSequence(moduleVo.getSequence());
    		uniqueBean.setDescription(moduleVo.getDescription());
    		
    		moduleService.saveOrUpdate(uniqueBean, false);
    		
    		return CommonResponse.success("修改成功");
    	}else{
    		String billCode = generator.generateBillCodeById(MODULE_BILL_CODE, tenantId);
    		moduleVo.setModuleCode(billCode);
    		ModuleEntity moduleEntity = BeanMapper.map(moduleVo, ModuleEntity.class);
    		moduleEntity.setId(IdWorker.getId());
    		if(moduleEntity.getParentId() != null && moduleEntity.getParentId() > 0) {
    			ModuleEntity uniqueBean = moduleService.queryDetail(moduleEntity.getParentId());
    			moduleEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + moduleEntity.getId());
    		}else{
    			moduleEntity.setInnerCode(moduleEntity.getId().toString());
    		}
    		moduleService.saveOrUpdate(moduleEntity, false);
    		
    		return CommonResponse.success("保存成功");
    	}
    }
    
    /**
	 * 查询列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
    	orderMap.put("sequence", "asc");
    	queryParam.setOrderMap(orderMap);
    	List<ModuleEntity> dataList = moduleService.queryList(queryParam, false);
    	List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
    	JSONObject jsonObject = new JSONObject();
    	jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
    	return CommonResponse.success(jsonObject);
    }
    
    /**
	 * 根据主键ID查询模块详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<ModuleVO> queryDetail(@RequestParam Long id) {
    	ModuleEntity entity = moduleService.queryDetail(id);
    	if(entity != null) {
    		ModuleVO moduleVo = BeanMapper.map(entity, ModuleVO.class);
    		return CommonResponse.success(moduleVo);
    	}else{
    		return CommonResponse.error("查询失败，参数不正确");
    	}
    }
	
	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		//先查询该模块下有没有子节点
		List<ModuleEntity> moduleDetails = moduleService.queryListByPid(id);
		if(moduleDetails != null && moduleDetails.size() > 0) {
			return CommonResponse.error("该模块下有子节点了， 不允许删除");
		}else{
			moduleService.delete(id);
			return CommonResponse.success("删除成功");
		}
	}
    
    /**
     * 查询模块树（模块）
     * @return
     */
	@RequestMapping(value = "/loadModuleTree", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<List<Map<String, Object>>> loadReferModuleTree() {
    	QueryParam queryParam = new QueryParam();
    	LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
    	orderMap.put("sequence", "asc");
    	queryParam.setOrderMap(orderMap);
    	List<ModuleEntity> dataList = moduleService.queryList(queryParam, false);
    	List<Map> resultMapList = new ArrayList<Map>();
    	Map map = null;
    	for(ModuleEntity entity:dataList) {
    		map = new HashMap<>();
    		map.put("id", entity.getId());
    		map.put("key", entity.getId());
    		map.put("title", entity.getModuleName());
    		map.put("parentId", entity.getParentId());
    		resultMapList.add(map);
    	}
    	List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
        return CommonResponse.success(result);
    }

	/**
	 * 查询租户下所有的模块树
	 *
	 * @return
	 */
    @GetMapping("/allModuleTreeRefer")
    public List<Map<String, Object>> moduleTreeRefer() {
		QueryParam queryParam = new QueryParam();
		LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
		orderMap.put("sequence", "asc");
		queryParam.setOrderMap(orderMap);
		List<ModuleEntity> dataList = moduleService.queryList(queryParam, false);
		List<Map> resultMapList = new ArrayList<Map>();
		Map map = null;
		for(ModuleEntity entity:dataList) {
			map = new HashMap<>();
			map.put("id", entity.getId());
			map.put("key", entity.getId());
			map.put("name", entity.getModuleName());
			map.put("code", entity.getModuleCode());
			map.put("parentId", entity.getParentId());
			resultMapList.add(map);
		}

		List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
		return result;
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/5/12
	 * @Description referTree 查询参照的模块树（模块）
	 * @Param [pageNumber, pageSize, relyNode]
	 * @Return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
	 */
	@RequestMapping(value = "/referTree", method = RequestMethod.GET)
	@ResponseBody
	public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber,@RequestParam Integer pageSize) {
		QueryParam queryParam = new QueryParam();
		LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
		orderMap.put("sequence", "asc");
		queryParam.setOrderMap(orderMap);
		List<ModuleEntity> dataList = moduleService.queryList(queryParam, false);
		List<Map> resultMapList = new ArrayList<>();
		Map map = null;
		for(ModuleEntity entity:dataList) {
			map = new HashMap<>();
			map.put("id", entity.getId());
			map.put("extdata", null);
			map.put("isLeaf", false);
			map.put("selectable", true);
			map.put("key", entity.getId());
			map.put("name", entity.getModuleName());
			map.put("code", entity.getModuleCode());
			map.put("parentId", entity.getParentId());
			resultMapList.add(map);
		}
		return ResultAsTree.createTreeData(resultMapList);
	}
	
	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			ModuleEntity entity = moduleService.queryDetail(publishVO.getModuleId());
			
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(entity);
			List<String> insertSql = getInsertSql(entity);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			String paramterStr = gson.toJson(params);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				logger.info("发布数据返回的结果：---------------"+result);
				return gson.fromJson(result, CommonResponse.class);
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布参照数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布参照数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(ModuleEntity entity) {
		if (entity == null) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		idStr = "(" + entity.getId() + ")";
		String baseTableName = "ejc_support_module";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
		sqlList.add(deleteBaseSql);
		return sqlList;
	}
	private List<String> getInsertSql(ModuleEntity entity) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<ModuleEntity> baseEntityList = new ArrayList<>();
		baseEntityList.add(entity);
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		return retList;
	}
	
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			ModuleEntity entity = moduleService.queryDetail(publishVO.getModuleId());
			
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(entity);
			List<String> insertSql = getInsertSql(entity);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			
			StringBuffer fileName = new StringBuffer();
			fileName.append("module.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}
}
