package com.ejianc.foundation.support.service;

import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 单据编码规则数据服务类
 */
public interface IBillCodeRuleService extends IBaseService<BillCodeRuleEntity> {


    /**
     * 根据主键列表ids，批量删除对应的单据编码规则
     *
     * @param ids
     */
    void delete(List<Long> ids);

    /**
     * 根据主键Id查询指定的单据编码规则详情
     *
     * @param id
     * @return
     */
    BillCodeRuleVO queryDetail(Long id);

    /**
     * 保存单据编码规则信息
     *
     * @param billCodeRuleVo
     */
    void save(BillCodeRuleVO billCodeRuleVo);

    /**
     * 根据编码ruleCode查询指定的单据编码规则详情
     *
     * @param ruleCode
     * @return
     */
    BillCodeRuleVO queryDetail(String ruleCode);

    /**
     * 根据编码和租户ID查询规则信息
     * 
     * @param code
     * @param tenantId
     * @return
     */
	BillCodeRuleVO queryDetailByCodeAndTenantId(String code, Long tenantId);
}
