package com.ejianc.foundation.support.service.impl;

import com.ejianc.foundation.support.bean.BillCodeRuleAttrEntity;
import com.ejianc.foundation.support.mapper.BillCodeRuleAttrMapper;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 编码规则子元素数据服务
 */
@Service("billCodeRuleService")
public class BillCodeRuleAttrServiceImpl extends BaseServiceImpl<BillCodeRuleAttrMapper, BillCodeRuleAttrEntity>
        implements IBillCodeRuleAttrService {

    @Autowired
    private BillCodeRuleAttrMapper billCodeRuleAttrMapper;

    @Override
    public void save(List<BillCodeRuleAttrVO> attrs, Long billCodeRuleId, boolean b) {
        List<BillCodeRuleAttrVO> snList = attrs.stream()
                .filter(r -> BillCodeRuleAttrVO.ELEM_TYPE_SN.equals(r.getElemType()))
                .collect(Collectors.toList());
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(CollectionUtils.isNotEmpty(snList) && snList.size() > 1) {
            throw new BusinessException("保存失败，编码规则有多个流水字段！");
        }
        if(b) {
            billCodeRuleAttrMapper.deleteByRuleId(billCodeRuleId, tenantId);
        }
        List<BillCodeRuleAttrEntity> saveList = BeanMapper.mapList(attrs, BillCodeRuleAttrEntity.class);
        saveList.forEach(attr -> {
            attr.setBillCodeRuleId(billCodeRuleId);
            if(BillCodeRuleAttrVO.ELEM_TYPE_TIME.equals(attr.getElemType())) {
                attr.setDateElemDisplayFormat(BillCodeRuleAttrVO.DATEFORMAT_YYYYMMDD);
            }
            //自动填充
            attr.setFillStyle(1);
            //填充0
            attr.setFillSign("0");
            attr.setCreateTime(null);
            attr.setCreateUserCode(InvocationInfoProxy.getUsercode());
            attr.setTenantId(tenantId);
        });

        super.saveOrUpdateBatch(saveList);
    }

    @Override
    public List<BillCodeRuleAttrVO> getListByProperties(QueryParam param, boolean isEs) {
        List<BillCodeRuleAttrVO> resp = new ArrayList<>();
        List<BillCodeRuleAttrEntity> eList = super.queryList(param, isEs);
        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, BillCodeRuleAttrVO.class);
        }
        return resp;
    }
}
