/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.supplier.mapper.SuplCategoryMapper;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SuplCategoryServiceImpl
extends BaseServiceImpl<SuplCategoryMapper, SupplierCategoryEntity>
implements ISuplCategoryService {
    private static final String SUPPLIER_CATEGORY_BILL_CODE = "SUPPORT_SUPPLIER_CATEGORY";
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private IBillTypeService billTypeService;

    @Override
    public void saveOrUpdate(SupplierCategoryVO supplierCategoryVo, Integer billType) throws BillCodeException {
        supplierCategoryVo.setBillType(billType);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (supplierCategoryVo.getId() != null && supplierCategoryVo.getId() > 0L) {
            SupplierCategoryEntity uniqueBean = (SupplierCategoryEntity)((Object)((SuplCategoryMapper)this.baseMapper).selectById(supplierCategoryVo.getId()));
            uniqueBean.setCode(supplierCategoryVo.getCode());
            uniqueBean.setName(supplierCategoryVo.getName());
            uniqueBean.setSequence(supplierCategoryVo.getSequence());
            uniqueBean.setDescription(supplierCategoryVo.getDescription());
            super.saveOrUpdate((Object)uniqueBean, false);
        } else {
            String billCode = this.generator.generateBillCodeById(SUPPLIER_CATEGORY_BILL_CODE, tenantId);
            supplierCategoryVo.setCode(billCode);
            SupplierCategoryEntity supplierCategoryEntity = (SupplierCategoryEntity)((Object)BeanMapper.map((Object)supplierCategoryVo, SupplierCategoryEntity.class));
            supplierCategoryEntity.setId(IdWorker.getId());
            if (supplierCategoryEntity.getParentId() != null && supplierCategoryEntity.getParentId() > 0L) {
                SupplierCategoryEntity uniqueBean = (SupplierCategoryEntity)((Object)((SuplCategoryMapper)this.baseMapper).selectById(supplierCategoryEntity.getParentId()));
                supplierCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + supplierCategoryEntity.getId());
            } else {
                supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
            }
            super.saveOrUpdate((Object)supplierCategoryEntity, false);
        }
    }

    @Override
    public SupplierCategoryEntity queryDetail(Long id) {
        SupplierCategoryEntity entity = (SupplierCategoryEntity)((Object)((SuplCategoryMapper)this.baseMapper).selectById(id));
        return entity;
    }

    @Override
    public List<SupplierCategoryVO> queryListByPid(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)id);
        List entities = ((SuplCategoryMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, SupplierCategoryVO.class);
        }
        return null;
    }

    @Override
    public String delete(Long id) {
        CommonResponse<String> response = this.billTypeService.checkQuote("05", id);
        if (!response.isSuccess()) {
            return "\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg();
        }
        ((SuplCategoryMapper)this.baseMapper).deleteById(id);
        return "\u5220\u9664\u6210\u529f";
    }

    @Override
    public List<SupplierCategoryEntity> treeList(QueryParam queryParam, String code, Integer billType) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("billType", new Parameter("eq", (Object)billType));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("code", new Parameter("eq", (Object)code));
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = super.queryList(queryParam, false);
        return dataList;
    }

    @Override
    public List<Map<String, Object>> querySupplierRefTree(String searchText, String code, Integer billType) {
        try {
            QueryParam queryParam = new QueryParam();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
            }
            queryParam.getParams().put("code", new Parameter("ne", (Object)code));
            queryParam.getParams().put("billType", new Parameter("eq", (Object)billType));
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("sequence", "asc");
            List dataList = super.queryList(queryParam, false);
            ArrayList resultMapList = new ArrayList();
            HashMap<String, Object> map = null;
            for (SupplierCategoryEntity entity : dataList) {
                map = new HashMap<String, Object>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getName());
                map.put("title", entity.getName());
                map.put("parentId", entity.getParentId());
                resultMapList.add(map);
            }
            List result = ResultAsTree.createTreeData(resultMapList);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

