package com.ejianc.foundation.supplier.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/supplierAccountApi/")
public class SupplierAccountApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISuplSupplierService supplierService;
    /**
     * 同步准入数据
     *
     * @return
     */
    @RequestMapping(value = "/sysSupplier", method = RequestMethod.POST)
    public CommonResponse<String> sysSupplier(@RequestBody SuplSupplierVO supplierVo) {
        logger.info("同步供方开始----------");
        supplierService.sysSupplier(supplierVo);
        logger.info("同步供方开始----------");
        return CommonResponse.success("同步成功！");
    }

    /**
     * 同步评价等级
     * @param supplierId
     * @param evaluationGrade
     * @return
     */
    @GetMapping("/syEvaluationGrade")
    public CommonResponse<String> syEvaluationGrade(@RequestParam(value = "supplierId") String supplierId,
                                                    @RequestParam(value = "evaluationGrade") Long evaluationGrade) {
        LambdaUpdateWrapper<SupplierEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(SupplierEntity::getEvaluationGrade, evaluationGrade);
        lambd.in(SupplierEntity::getId, supplierId);
        supplierService.update(lambd);
        return CommonResponse.success("同步评价等级成功！");
    }
}
