/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"wz/category"})
public class WzCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer BILL_TYPE = 1;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private ISuplSupplierService supplierService;
    @Value(value="${insideSupplierCategoryCode:SPC-inside}")
    private String insideSupplierCategoryCode;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody SupplierCategoryVO supplierCategoryVo) throws BillCodeException {
        this.categoryService.saveOrUpdate(supplierCategoryVo, BILL_TYPE);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierCategoryVO> queryDetail(@RequestParam Long id) {
        SupplierCategoryEntity entity = this.categoryService.queryDetail(id);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SupplierCategoryVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<SupplierCategoryVO> children = this.categoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u6709\u5b50\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<SupplierVO> supplierList = this.supplierService.queryListByCategoryId(id);
        if (supplierList != null && supplierList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u6709\u4f9b\u65b9\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        String msg = this.categoryService.delete(id);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<SupplierCategoryEntity> dataList = this.categoryService.treeList(queryParam, this.insideSupplierCategoryCode, BILL_TYPE);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/querySupplierRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> querySupplierRefTree(@RequestParam(required=false) String searchText) {
        return this.categoryService.querySupplierRefTree(searchText, this.insideSupplierCategoryCode, BILL_TYPE);
    }
}

