package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("wz/category")
public class WzCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer BILL_TYPE = 1;

    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private ISuplSupplierService supplierService;

    @Value("${insideSupplierCategoryCode:SPC-inside}")
    private String insideSupplierCategoryCode;//内部供应商分类编码

    /**
     * 新增
     *
     * @param supplierCategoryVo
     * @return
     * @throws BillCodeException
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody SupplierCategoryVO supplierCategoryVo) throws BillCodeException {
        categoryService.saveOrUpdate(supplierCategoryVo, BILL_TYPE);
        return CommonResponse.success("保存成功");
    }

    /**
     * 根据主键ID查询供方分类详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierCategoryVO> queryDetail(@RequestParam Long id) {
        SupplierCategoryEntity entity = categoryService.queryDetail(id);
        if (entity != null) {
            return CommonResponse.success(BeanMapper.map(entity, SupplierCategoryVO.class));
        } else {
            return CommonResponse.error("查询失败，参数错误！");
        }
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        //先查询该分类下有没有子节点
        List<SupplierCategoryVO> children = categoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error("该分类有子节点不允许删除");
        } else {
            //查询该分类下有没有客户信息
            List<SupplierVO> supplierList = supplierService.queryListByCategoryId(id);
            if (supplierList != null && supplierList.size() > 0) {
                return CommonResponse.error("该分类下已有供方信息，不允许删除");
            } else {
                String msg = categoryService.delete(id);
                return CommonResponse.success(msg);
            }
        }
    }

    /**
     * 查询供方分类分页列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<SupplierCategoryEntity> dataList = categoryService.treeList(queryParam, insideSupplierCategoryCode, BILL_TYPE);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success(jsonObject);
    }

    /**
     * 供方分类树参照
     *
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/querySupplierRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> querySupplierRefTree(@RequestParam(required = false) String searchText) {
        return categoryService.querySupplierRefTree(searchText, insideSupplierCategoryCode, BILL_TYPE);
    }

}
