package com.ejianc.foundation.support.service;

import java.util.List;

import com.ejianc.foundation.support.bean.DefdocEntity;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IDefdocService extends IBaseService<DefdocEntity> {

	/**
	 * 根据主键查询bean
	 * 
	 * @param id
	 * @return
	 */
	DefdocVO queryDetail(Long id);

	/**
	 * 删除编码规则
	 * 
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 根据档案编号查询bean
	 * 
	 * @param defdocCode
	 * @return
	 */
	DefdocVO queryUniqueByCode(String defdocCode);

	/**
	 * 根据档案编号查询bean
	 *
	 * @param defdocCode
	 * @return
	 */
	List<DefdocVO> queryByCode(String defdocCode);

}
