package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.bean.HistoricalPerformanceEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.service.IHistoricalPerformanceService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.vo.HistoricalPerformanceVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.mapper.SuplSupplierMapper;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.supplier.vo.SuplBankAccountVO;
import com.ejianc.foundation.supplier.vo.SuplHistoricalPerformanceVO;
import com.ejianc.foundation.supplier.vo.SuplLinkerVO;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
public class SuplSupplierServiceImpl extends BaseServiceImpl<SuplSupplierMapper, SupplierEntity> implements ISuplSupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private ISuplCategoryService categoryService;
    @Autowired
    private IHistoricalPerformanceService historicalPerformanceService;
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<SupplierVO> queryListByCategoryId(Long categoryId) {
        QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("category_id", categoryId);
        List<SupplierEntity> entities = baseMapper.selectList(wrapper);
        if (entities != null) {
            return BeanMapper.mapList(entities, SupplierVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplierEntity entity = null;
        String operateType = null;
        //根据统一信用代码验重
        this.check(supplierVo);
        if (supplierVo.getId() != null && supplierVo.getId() > 0) { //修改
            entity = BeanMapper.map(supplierVo, SupplierEntity.class);
            operateType = "edit";
        } else { //新增
            throw new BusinessException("暂不允许新增");
        }

        //处理项目地区，转为省市区
        if (StringUtils.isNotBlank(entity.getArea())) {
            String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
            while (matcher.find()) {
                try {
                    entity.setRegion(matcher.group("town"));
                } catch (IllegalArgumentException e) {
                }
                String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
                String provinceAndCity = "";
                try {
                    provinceAndCity = matcher.group("provinceAndCity");
                } catch (IllegalArgumentException e) {
                }
                Matcher matcher2 = Pattern.compile(regex2).matcher(provinceAndCity);
                while (matcher2.find()) {
                    try {
                        entity.setProvince(matcher.group("province"));
                    } catch (IllegalArgumentException e) {
                    }
                    try {
                        String city = matcher2.group("city");
                        if (StringUtils.isBlank(city)) {
                            entity.setCity(entity.getProvince());
                        } else {
                            entity.setCity(matcher.group("city"));
                        }
                    } catch (IllegalArgumentException e) {
                    }

                }
            }
        }
        super.saveOrUpdate(entity);
        //子表
        List<SupplierLinkerVO> supplierLinkerVos = supplierVo.getGridheaders();
        List<SupplierLinkerEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for (SupplierLinkerVO supplierLinkerVo : supplierLinkerVos) {
            if ("add".equals(supplierLinkerVo.getRowState())) {
                SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
                supplierLinkerEntity.setSupplierId(entity.getId());
                saveOrUpldates.add(supplierLinkerEntity);
            } else if ("edit".equals(supplierLinkerVo.getRowState())) {
                SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
                saveOrUpldates.add(supplierLinkerEntity);
            } else if ("del".equals(supplierLinkerVo.getRowState())) {
                deleteIds.add(supplierLinkerVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            supplierLinkerService.removeByIds(deleteIds, false);
        }
        //子表
        List<HistoricalPerformanceVO> performanceVos = supplierVo.getPerformanceVos();
        List<HistoricalPerformanceEntity> saves = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        for (HistoricalPerformanceVO vo : performanceVos) {
            if ("add".equals(vo.getRowState())) {
                HistoricalPerformanceEntity performanceEntity = BeanMapper.map(vo, HistoricalPerformanceEntity.class);
                performanceEntity.setSupplierId(entity.getId());
                saves.add(performanceEntity);
            } else if ("edit".equals(vo.getRowState())) {
                HistoricalPerformanceEntity performanceEntity = BeanMapper.map(vo, HistoricalPerformanceEntity.class);
                saves.add(performanceEntity);
            } else if ("del".equals(vo.getRowState())) {
                delIds.add(vo.getId());
            }
        }
        if (saves.size() > 0) {
            historicalPerformanceService.saveOrUpdateBatch(saves, saves.size(), false);
        }
        if (delIds.size() > 0) {
            historicalPerformanceService.removeByIds(delIds, false);
        }

        SupplierVO vo = this.queryDetail(entity.getId());
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = categoryService.selectById(vo.getCategoryId());
        parent.put("id", e.getId());
        parent.put("code", e.getCode());
        parent.put("name", e.getName());
        vo.setParent(parent);
        return CommonResponse.success(vo);
    }

    @Override
    public SupplierVO queryDetail(Long id) {
        SupplierEntity entity = baseMapper.selectById(id);
        if (entity != null) {
            SupplierVO supplierVo = BeanMapper.map(entity, SupplierVO.class);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List<SupplierLinkerEntity> supplierLinkers = supplierLinkerService.queryList(queryParam, false);
            if (supplierLinkers != null && supplierLinkers.size() > 0) {
                List<SupplierLinkerVO> supplierLinkerVos = BeanMapper.mapList(supplierLinkers, SupplierLinkerVO.class);
                supplierVo.setGridheaders(supplierLinkerVos);
            }
            List<HistoricalPerformanceEntity> historicalPerformanceEntities = historicalPerformanceService.queryList(queryParam, false);
            if (historicalPerformanceEntities != null && historicalPerformanceEntities.size() > 0) {
                List<HistoricalPerformanceVO> vos = BeanMapper.mapList(historicalPerformanceEntities, HistoricalPerformanceVO.class);
                supplierVo.setPerformanceVos(vos);
            }
            return supplierVo;
        }
        return null;
    }

    @Override
    public void deleteSupplier(List<Long> ids) {
        for (Long id : ids) {
            //先删除供方联系人
            supplierLinkerService.deleteBySupplierId(id);
            historicalPerformanceService.deleteBySupplierId(id);
            baseMapper.deleteById(id);
        }
    }

    @Override
    public IPage<SupplierVO> queryPageList(QueryParam queryParam, Integer billType) {
        Map<String, Parameter> paramMap = queryParam.getParams();
        if (paramMap.get("categoryId") != null) {
            if (StringUtils.isNotBlank(paramMap.get("categoryId").getValue().toString())) {
                SupplierCategoryEntity categoryEntity = categoryService.queryDetail(Long.parseLong(paramMap.get("categoryId").getValue().toString()));
                if (categoryEntity != null) {
                    LambdaQueryWrapper<SupplierCategoryEntity> lambd = new LambdaQueryWrapper<>();
                    lambd.like(SupplierCategoryEntity::getInnerCode, categoryEntity.getInnerCode());
                    List<SupplierCategoryEntity> list = categoryService.list(lambd);
                    List<Long> ids = list.stream().map(SupplierCategoryEntity::getId).collect(Collectors.toList());
                    queryParam.getParams().remove("categoryId");
                    queryParam.getParams().put("categoryId", new Parameter(QueryParam.IN, ids));
                }
            } else {
                queryParam.getParams().remove("categoryId");
            }
        }
        if (billType == 1) {
            queryParam.getParams().put("supplierFlag", new Parameter(QueryParam.EQ, 1));
        }
        if (billType == 2) {
            queryParam.getParams().put("subFlag", new Parameter(QueryParam.EQ, 1));
        }
        queryParam.getParams().put("blacklistFlag", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SupplierEntity> page = super.queryPage(queryParam, false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));
        return pageData;
    }

    @Override
    public void sysSupplier(SuplSupplierVO supplierVo) {
        Integer supplierFlag = supplierVo.getSupplierFlag() == null ? 0 : supplierVo.getSupplierFlag();
        Integer subFlag = supplierVo.getSubFlag() == null ? 0 : supplierVo.getSubFlag();
        if (supplierFlag == subFlag) {
            logger.info("同时属于物资或分包");
            throw new BusinessException("同步失败");
        }
        List<SuplLinkerVO> linkerList = supplierVo.getLinkerList();
        List<SuplHistoricalPerformanceVO> historicalPerformanceList = supplierVo.getHistoricalPerformanceList();
        List<SuplBankAccountVO> bankAccountList = supplierVo.getBankAccountList();

        logger.info("同步供应商");
        long id = IdWorker.getId();
        SupplierEntity entity = BeanMapper.map(supplierVo, SupplierEntity.class);
        entity.setBlacklistFlag(0);
        entity.setRedlistFlag(0);
        entity.setCreateTime(new Date());
        entity.setAccessId(entity.getId());
        entity.setId(id);
        entity.setCode(supplierVo.getBillCode());
        super.saveOrUpdate(entity);

        logger.info("同步联系人");
        if (linkerList != null && linkerList.size() > 0) {
            List<SupplierLinkerEntity> links = new ArrayList<>();
            for (SuplLinkerVO link : linkerList) {
                SupplierLinkerEntity linkerEntity = BeanMapper.map(link, SupplierLinkerEntity.class);
                linkerEntity.setId(null);
                linkerEntity.setSupplierId(id);
                linkerEntity.setLinkman(link.getLinkMan());
                links.add(linkerEntity);
            }
            supplierLinkerService.saveOrUpdateBatch(links, links.size(), false);
        }
        logger.info("同步企业历史业绩");
        if (historicalPerformanceList != null && historicalPerformanceList.size() > 0) {
            List<HistoricalPerformanceEntity> hises = BeanMapper.mapList(historicalPerformanceList, HistoricalPerformanceEntity.class);
            for (HistoricalPerformanceEntity his : hises) {
                his.setId(null);
                his.setSupplierId(id);
            }
            historicalPerformanceService.saveOrUpdateBatch(hises, hises.size(), false);
        }
        logger.info("同步银行账户");
        if (bankAccountList != null && bankAccountList.size() > 0) {
            List<BankAccountEntity> hises = BeanMapper.mapList(bankAccountList, BankAccountEntity.class);
            for (BankAccountEntity his : hises) {
                his.setId(null);
                his.setSupplierId(id);
                his.setSupplierName(entity.getName());
                his.setEnabled(1);
            }
            bankAccountService.saveOrUpdateBatch(hises, hises.size(), false);
        }
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(supplierVo.getId()), "BT211103000000001", null,
                String.valueOf(id), "BT200422000000028", null);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());
    }

    @Override
    public List<SupplierVO> excelExport(QueryParam queryParam, Integer billType) {
        Map<String, Parameter> paramMap = queryParam.getParams();
        if (paramMap.get("categoryId") != null) {
            if (StringUtils.isNotBlank(paramMap.get("categoryId").getValue().toString())) {
                SupplierCategoryEntity categoryEntity = categoryService.queryDetail(Long.parseLong(paramMap.get("categoryId").getValue().toString()));
                if (categoryEntity != null) {
                    LambdaQueryWrapper<SupplierCategoryEntity> lambd = new LambdaQueryWrapper<>();
                    lambd.like(SupplierCategoryEntity::getInnerCode, categoryEntity.getInnerCode());
                    List<SupplierCategoryEntity> list = categoryService.list(lambd);
                    List<Long> ids = list.stream().map(SupplierCategoryEntity::getId).collect(Collectors.toList());
                    queryParam.getParams().remove("categoryId");
                    queryParam.getParams().put("categoryId", new Parameter(QueryParam.IN, ids));
                }
            } else {
                queryParam.getParams().remove("categoryId");
            }
        }
        if (billType == 1) {
            queryParam.getParams().put("supplierFlag", new Parameter(QueryParam.EQ, 1));
        }
        if (billType == 2) {
            queryParam.getParams().put("subFlag", new Parameter(QueryParam.EQ, 1));
        }
        queryParam.getParams().put("blacklistFlag", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<SupplierEntity> list = super.queryList(queryParam, false);
        List<SupplierVO> vos = BeanMapper.mapList(list, SupplierVO.class);

        for (SupplierVO supplierVo : vos) {
            DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getEnterpriseNature());
            if (taxPayerTypeVo != null) {
                supplierVo.setEnterpriseNatureName(taxPayerTypeVo.getName());
            }
            if (supplierVo.getEvaluationGrade() != null) {
                if (supplierVo.getEvaluationGrade() == 0) {
                    supplierVo.setEvaluationGradeName("不合格");
                }
                if (supplierVo.getEvaluationGrade() == 1) {
                    supplierVo.setEvaluationGradeName("合格");
                }
            }

            QueryParam linkerQueryParam = new QueryParam();
            linkerQueryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
            linkerQueryParam.getParams().put("defaultFlag", new Parameter(QueryParam.EQ, 1));
            List<SupplierLinkerEntity> linkerEntities = supplierLinkerService.queryList(linkerQueryParam, false);
            if (linkerEntities != null && linkerEntities.size() > 0) {
                SupplierLinkerEntity linkerEntity = linkerEntities.get(0);
                supplierVo.setLinkman(linkerEntity.getLinkman());
                supplierVo.setCellphone(linkerEntity.getCellphone());
            }
        }
        return vos;
    }

    @Override
    public void saveBlackList(List<Long> ids) {
        Long operateId = sessionManager.getUserContext().getUserId(); // 操作人id
        String operateName = sessionManager.getUserContext().getUserName(); // 操作人名称
        Long operateOrgId = sessionManager.getUserContext().getOrgId(); // 操作人所属组织id
        String operateOrgName = sessionManager.getUserContext().getOrgName(); // 操作人所属组织名称

        LambdaUpdateWrapper<SupplierEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(SupplierEntity::getOperateId, operateId);
        lambd.set(SupplierEntity::getOperateName, operateName);
        lambd.set(SupplierEntity::getOperateTime, new Date());
        lambd.set(SupplierEntity::getOperateOrgId, operateOrgId);
        lambd.set(SupplierEntity::getOperateOrgName, operateOrgName);
        lambd.set(SupplierEntity::getBlacklistFlag, 1);
        lambd.in(SupplierEntity::getId, ids);
        super.update(lambd);
    }

    @Override
    public void delBlackList(List<Long> ids) {
        LambdaUpdateWrapper<SupplierEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(SupplierEntity::getBlacklistFlag, 0);
        lambd.in(SupplierEntity::getId, ids);
        super.update(lambd);
    }

    @Override
    public IPage<SupplierVO> queryBlackList(QueryParam param, Integer billType) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
//        fuzzyFields.add("categoryName");
//        fuzzyFields.add("legal");
//        fuzzyFields.add("orgName");
//        fuzzyFields.add("operateName");
//        fuzzyFields.add("operateOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("blacklistFlag", new Parameter(QueryParam.EQ, 1));
        if (billType == 1) {
            param.getParams().put("supplierFlag", new Parameter(QueryParam.EQ, 1));
        }
        if (billType == 2) {
            param.getParams().put("subFlag", new Parameter(QueryParam.EQ, 1));
        }
        IPage<SupplierEntity> page = super.queryPage(param, false);
        List<SupplierVO> supplierVOS = BeanMapper.mapList(page.getRecords(), SupplierVO.class);
        for (SupplierVO supplierVo : supplierVOS) {
            DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getEnterpriseNature());
            if (taxPayerTypeVo != null) {
                supplierVo.setEnterpriseNatureName(taxPayerTypeVo.getName());
            }
        }
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(supplierVOS);
        return pageData;
    }

    @Override
    public List<SupplierVO> blackExcelExport(QueryParam param, Integer billType) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
//        fuzzyFields.add("categoryName");
//        fuzzyFields.add("legal");
//        fuzzyFields.add("orgName");
//        fuzzyFields.add("operateName");
//        fuzzyFields.add("operateOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("blacklistFlag", new Parameter(QueryParam.EQ, 1));
        if (billType == 1) {
            param.getParams().put("supplierFlag", new Parameter(QueryParam.EQ, 1));
        }
        if (billType == 2) {
            param.getParams().put("subFlag", new Parameter(QueryParam.EQ, 1));
        }
        List<SupplierEntity> list = super.queryList(param, false);
        List<SupplierVO> supplierVOS = BeanMapper.mapList(list, SupplierVO.class);
        for (SupplierVO supplierVo : supplierVOS) {
            DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getEnterpriseNature());
            if (taxPayerTypeVo != null) {
                supplierVo.setEnterpriseNatureName(taxPayerTypeVo.getName());
            }
            if (supplierVo.getEvaluationGrade() != null) {
                if (supplierVo.getEvaluationGrade() == 0) {
                    supplierVo.setEvaluationGradeName("不合格");
                }
                if (supplierVo.getEvaluationGrade() == 1) {
                    supplierVo.setEvaluationGradeName("合格");
                }
            }
        }
        return supplierVOS;
    }

    @Override
    public void saveRedList(List<Long> ids) {
        LambdaUpdateWrapper<SupplierEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(SupplierEntity::getRedlistFlag, 1);
        lambd.in(SupplierEntity::getId, ids);
        super.update(lambd);
    }

    @Override
    public void delRedList(List<Long> ids) {
        LambdaUpdateWrapper<SupplierEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(SupplierEntity::getRedlistFlag, 0);
        lambd.in(SupplierEntity::getId, ids);
        super.update(lambd);
    }

    // 校验同统一信用代码
    private void check(SupplierVO supplierVo) {
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        if (supplierVo.getId() != null) {
            queryWrapper.ne("id", supplierVo.getId());
        }
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("social_credit_code", supplierVo.getSocialCreditCode());
        List<SupplierEntity> list = this.list(queryWrapper);
        if (list != null && list.size() > 0) {
            throw new BusinessException("统一社会信用代码已存在！！！");
        }
    }
}
