package com.ejianc.foundation.support.controller.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdRelationApi;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;


@RestController
@RequestMapping("/api/billTypeApi/")
public class BillTypeApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Value("${common.env.base-host}")
	private String baseHost; 
	private Gson gson = new Gson();

	@Autowired
	private IBillTypeService billTypeService;

	@Autowired
	private IMdRelationApi mdRelationApi;

	@Autowired
	private IMdApi mdApi;

	/**
	 * 根据单据编码获取单据信息
	 *
	 * @param id 编码规则主键ID
	 * @return
	 */
	@GetMapping("getByCode")
	public CommonResponse<BillTypeVO> getCodeBatchByRuleCode(@RequestParam(value = "code") String code) {
		
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("billCode", new Parameter("eq",code));
		IPage<BillTypeEntity> pageData = billTypeService.queryPage(queryParam, false);
		if(pageData.getTotal()>0){
			BillTypeVO vo = BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
			return CommonResponse.success(vo);
		}
		logger.error("根据单据编码获取单据信息 ---- 获取失败code={}",code);
		return CommonResponse.error("获取失败");
	}

	/**
	 * 根据单据类型 主键查询单据类型信息
	 *
	 * @return
	 */
	@GetMapping("getById")
	public CommonResponse<BillTypeVO> getById(@RequestParam(value = "id") Long id) {
		BillTypeVO vo = billTypeService.queryDetail(id);
		return CommonResponse.success(vo);
	}

	/**
	 * 根据billType查询元数据工程+实体详情（不包含字段）
	 * 
	 * @param billType
	 * @return
	 */
	@RequestMapping(value = "queryMetadataByBillType", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<MdReferVO> queryMetadataByBillType(@RequestParam(value="billTypeCode", required=true) String billTypeCode) {
		try{
			CommonResponse<BillTypeVO> back = this.getCodeBatchByRuleCode(billTypeCode);
			if(back.getCode()==0){
				logger.info("根据单据类型编码："+billTypeCode+"");
				if(back.getData()!=null&&back.getData().getMetadataId()!=null){
					CommonResponse<MdReferVO> refVO = mdApi.queryMetadataById(back.getData().getMetadataId());
					if(refVO.getCode()==0&&refVO.getData()!=null){
						return CommonResponse.success(refVO.getData());
					}else{
						return CommonResponse.error("未查询到该单据类型对应的元数据");
					}
				}else{
					logger.error("单据类型编码："+billTypeCode+"未与元数据关联");
					return CommonResponse.error("该单据类型未与元数据关联");
				}
				
			}else{
				logger.error("根据单据类型编码："+billTypeCode+"未查询单据类型对应的单据实体");
				return CommonResponse.error("未查询到该单据类型对应的单据实体");
			}
			
		}catch(Exception e){
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	/**
	 * 根据单据编码引用检查
	 *
	 * @param id 编码规则主键ID
	 * @return
	 * @throws BillCodeException 
	 */
	@GetMapping("checkQuote")
	public CommonResponse<String> checkQuote(@RequestParam(value = "billTypeCode") String billTypeCode,@RequestParam(value = "billId") Long billId){
		return billTypeService.checkQuote(billTypeCode,billId);
	}
	
}
