package com.ejianc.foundation.support.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IBillTypeService extends IBaseService<BillTypeEntity> {

	/**
	 * 删除
	 * 
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 查询详情
	 * 
	 * @param id
	 * @return
	 */
	BillTypeVO queryDetail(Long id);

	/**
	 * 查询单据类型树
	 *
	 * @return
	 */
	List<Map<String, Object>> getBillTypeTree();

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/7/14 单据编码引用校验
	 * @Description checkQuote
	 * @Param [billTypeCode, billId]
	 * @Return void
	 */
	CommonResponse<String> checkQuote(String billTypeCode, Long billId);
}
