package com.ejianc.foundation.supplier.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/supplierAccountApi/")
public class SupplierAccountApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISuplSupplierService supplierService;

    @Autowired
    private ISuplCategoryService categoryService;

    /**
     * 同步准入数据
     *
     * @return
     */
    @RequestMapping(value = "/sysSupplier", method = RequestMethod.POST)
    public CommonResponse<String> sysSupplier(@RequestBody SuplSupplierVO supplierVo) {
        logger.info("同步供方开始----------");
        supplierService.sysSupplier(supplierVo);
        logger.info("同步供方开始----------");
        return CommonResponse.success("同步成功！");
    }

    /**
     * 同步评价等级
     *
     * @param supplierId
     * @param evaluationGrade
     * @return
     */
    @GetMapping("/syEvaluationGrade")
    public CommonResponse<String> syEvaluationGrade(@RequestParam(value = "supplierId") Long supplierId,
                                                    @RequestParam(value = "evaluationGrade") Integer evaluationGrade) {
        LambdaUpdateWrapper<SupplierEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(SupplierEntity::getEvaluationGrade, evaluationGrade);
        lambd.in(SupplierEntity::getId, supplierId);
        supplierService.update(lambd);
        return CommonResponse.success("同步评价等级成功！");
    }

    /**
     * 根据准入查询供方
     *
     * @param accessId
     * @return
     */
    @GetMapping("/getSupplierByAccessId")
    public CommonResponse<List<SupplierVO>> getSupplierByAccessId(@RequestParam(value = "accessId") Long accessId) {
        LambdaQueryWrapper<SupplierEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(SupplierEntity::getDr, 0);
        lambd.eq(SupplierEntity::getAccessId, accessId);
        List<SupplierEntity> list = supplierService.list(lambd);
        return CommonResponse.success(BeanMapper.mapList(list,SupplierVO.class));
    }

    @RequestMapping(value = "/findChildrenByParentId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>>findChildrenByParentId(Long categoryId){
        return CommonResponse.success("查询成功",categoryService.findChildrenByParentId(categoryId));
    }
}
