package com.ejianc.foundation.support.controller;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.support.bean.BillCodeRuleAttrEntity;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.bean.ReferEntity;
import com.ejianc.foundation.support.bean.ReferShowfieldEntity;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.service.IReferShowfieldService;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 参照
 * 
 * @author liyongjia
 *
 */
@Controller
@RequestMapping("refer")
public class ReferController implements Serializable {
	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	private Gson gson = new Gson();

	private static final long serialVersionUID = 1L;

	@Autowired
	private IReferService referService;
	@Autowired
	private IModuleService moduleService;
	@Autowired
	private IReferShowfieldService referShowfieldService;
	
	/**
	 * 查询列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		IPage<ReferVO> pageData = referService.pageList(queryParam, false);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ReferVO> queryDetail(@RequestParam Long id) {
		ReferVO ReferVo = referService.queryDetail(id);
		return CommonResponse.success(ReferVo);
	}

	/**
	 * 新增and修改功能
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> save(@RequestBody ReferVO ReferVo) {
		return referService.saveOrUpdate(ReferVo, false);
	}

	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		return referService.delete(ids);
	}
	
	@RequestMapping(value = "/findByCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
		ReferVO vo = referService.findByCode(refCode);
		/** 处理聚合参照数据 */
		if(vo.getRefType().equals("multiInOne")){
			if(StringUtils.isNotEmpty(vo.getMultiRefCode())){
				String[] codes = vo.getMultiRefCode().split(",");
				for (int i = 0; i < codes.length; i++) {
					String code = codes[i];
					ReferVO multiRef = referService.findByCode(code);
					vo.getMultiRefInfo().add(multiRef);
				}
			}
		}
		return CommonResponse.success(vo);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/5/12
	 * @Description refdata
	 * @Param QueryParam queryParam
	 * @Return
	 */
	@RequestMapping(value = "/refdata", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<ReferVO>> refdata(@RequestParam Integer pageNumber,
											  @RequestParam Integer pageSize,
											  String relyCondition,
											  String relyNode ,
											  String searchText) {
		QueryParam queryParam = new QueryParam();
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		Map<String, Parameter>  param = queryParam.getParams();
		if(!StringUtils.isEmpty(relyCondition)){
			param.put("referModule",new Parameter(QueryParam.EQ,relyCondition.split("=")[1]));
		}
		if(!StringUtils.isEmpty(searchText)){
			param.put("refName",new Parameter(QueryParam.LIKE,searchText));
		}
		IPage<ReferVO> pageData = referService.pageList(queryParam, false);
		return CommonResponse.success("查询数表参照成功", pageData);
	}
	
	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			String scope = publishVO.getScope();
			if (StringUtils.isBlank(scope)) {
				return CommonResponse.error("发布数据失败:数据范围不能为空!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<ReferEntity> baseEntities = null;
//			List<ReferClassEntity> classEntities = null;
			List<ReferShowfieldEntity> fieldEntities = null;
			if ("all".equalsIgnoreCase(scope)) { // 模块下的所有参照(保证效率和影响数据范围,单次最多只能同步一个模块下的所有数据)
				QueryParam queryParam = new QueryParam();
				List<ModuleVO> moduleVOs = moduleService.queryAllChildrenByPid(publishVO.getModuleId());
				List<Long> moduleIds = new ArrayList<>();
				for(ModuleVO vo : moduleVOs){
					moduleIds.add(vo.getId());
				}
				Map<String, Parameter> params = new HashMap<>();
				params.put("referModule", new Parameter("in",moduleIds));
				queryParam.setParams(params);
				baseEntities = referService.queryList(queryParam, false);
			} else if ("select".equalsIgnoreCase(scope)) { // 选中数据
				if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
					baseEntities = (List<ReferEntity>) referService.listByIds(publishVO.getIdList());
				}else{
					return CommonResponse.error("未选中要发布的数据");
				}
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (ReferEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getRefCode())) {
						codes.add(entity.getRefCode());
					}
				}
			}
//			fieldEntities = referFieldService.findByReferIds(ids);
			QueryWrapper<ReferShowfieldEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.in("refer_id", ids);
			queryWrapper.eq("dr", 0);
			queryWrapper.orderByAsc("show_order");
			fieldEntities = referShowfieldService.querylist(queryWrapper);
//			classEntities = referClassService.findByReferIds(ids);
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities, fieldEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			gson = new GsonBuilder().disableHtmlEscaping().create();
			String paramterStr = gson.toJson(params);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				logger.info("发布数据返回的结果：---------------"+result);
				return gson.fromJson(result, CommonResponse.class);
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布参照数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布参照数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
		if (ids == null || ids.isEmpty()) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		for (Long id : ids) {
			idStr = idStr + "'" + id + "',";
		}
		String codeStr = "";
		for (String code : codes) {
			codeStr = codeStr + "'" + code + "',";
		}
		idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
		codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
		String fieldTableName = "ejc_support_refer_showfield";
		String baseTableName = "ejc_support_refer";
		String deleteFieldSql = " delete from " + fieldTableName + " where refer_id in " + idStr + ";";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
		String deleteByCodeSql = " delete from " + baseTableName + " where dr =1 and ref_code in " + codeStr + ";";
		sqlList.add(deleteFieldSql);
		sqlList.add(deleteBaseSql);
		sqlList.add(deleteByCodeSql);
		return sqlList;
	}
	private List<String> getInsertSql(List<ReferEntity> baseEntityList, List<ReferShowfieldEntity> fieldEntityList) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		List<String> fieldInsertSql = DataTransferUtil.getInsertSql(fieldEntityList);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		if (fieldInsertSql != null && !fieldInsertSql.isEmpty()) {
			retList.addAll(fieldInsertSql);
		}
		return retList;
	}
	
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			String scope = publishVO.getScope();
			if (StringUtils.isBlank(scope)) {
				throw new BusinessException("导出脚本失败:数据范围不能为空!");
			}

			List<Long> ids = null;
			List<String> codes = null;
			List<ReferEntity> baseEntities = null;
//			List<ReferClassEntity> classEntities = null;
			List<ReferShowfieldEntity> fieldEntities = null;
			if ("all".equalsIgnoreCase(scope)) { // 模块下的所有参照(保证效率和影响数据范围,单次最多只能同步一个模块下的所有数据)
				QueryParam queryParam = new QueryParam();
				List<ModuleVO> moduleVOs = moduleService.queryAllChildrenByPid(publishVO.getModuleId());
				List<Long> moduleIds = new ArrayList<>();
				for(ModuleVO vo : moduleVOs){
					moduleIds.add(vo.getId());
				}
				Map<String, Parameter> params = new HashMap<>();
				params.put("referModule", new Parameter("in",moduleIds));
				queryParam.setParams(params);
				baseEntities = referService.queryList(queryParam, false);
			} else if ("select".equalsIgnoreCase(scope)) { // 选中数据
				if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
					baseEntities = (List<ReferEntity>) referService.listByIds(publishVO.getIdList());
				}else{
					throw new BusinessException("未选中要导出脚本的数据!");
				}
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (ReferEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getRefCode())) {
						codes.add(entity.getRefCode());
					}
				}
			}
			QueryWrapper<ReferShowfieldEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.in("refer_id", ids);
			queryWrapper.eq("dr", 0);
			queryWrapper.orderByAsc("show_order");
			fieldEntities = referShowfieldService.querylist(queryWrapper);
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities, fieldEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			
			StringBuffer fileName = new StringBuffer();
			fileName.append("billType.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}
}
