/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.mapper.DefdocDetailMapper;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefdocDetailServiceImpl
implements IDefdocDetailService {
    @Autowired
    private DefdocDetailMapper defdocDetailMapper;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;

    private boolean isOmsTenant() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.OMS_TENANT.equals(tenantId.toString());
    }

    private boolean hasData(Long defId, Long tenantId) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("tenantId", tenantId);
        condition.put("defdocId", defId);
        List<DefdocDetailEntity> resultList = this.defdocDetailMapper.queryList(condition);
        return !ListUtil.isEmpty(resultList);
    }

    @Override
    public List<DefdocDetailVO> queryListByDefdocId(List<Long> ids) {
        StringBuffer buffer = new StringBuffer();
        if (ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                buffer.append(ids.get(i));
                if (i >= ids.size() - 1) continue;
                buffer.append(",");
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<DefdocDetailEntity> entity = this.defdocDetailMapper.queryListByDefdocId(buffer.toString(), tenantId);
        if (entity != null) {
            return BeanMapper.mapList(entity, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public List<DefdocDetailVO> getDefDocByDefId(Long defId) {
        List<DefdocDetailEntity> list = this.defdocDetailMapper.getDefDocByDefId(defId, InvocationInfoProxy.getTenantid());
        if (list != null) {
            return BeanMapper.mapList(list, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public DefdocDetailVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        DefdocDetailEntity entity = this.defdocDetailMapper.queryDetail(id, tenantId);
        if (entity != null) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entity), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public DefdocDetailVO queryDetailOMS_TENANT(Long id) {
        DefdocDetailEntity entity = this.defdocDetailMapper.queryDetail(id, Long.parseLong(this.OMS_TENANT));
        if (entity != null) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entity), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.defdocDetailMapper.deleteBean(id, tenantId);
    }

    @Override
    public List<DefdocDetailVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<DefdocDetailEntity> entityList = this.defdocDetailMapper.queryListByPid(id, tenantId);
        if (entityList != null) {
            return BeanMapper.mapList(entityList, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public void updateEnabled(DefdocDetailVO defdocDetailVo) {
        DefdocDetailVO condition = this.queryDetail(defdocDetailVo.getId());
        this.defdocDetailMapper.updateEnabled(defdocDetailVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
    }

    @Override
    public DefdocDetailVO queryDetailByName(String name) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        condition.put("name", name);
        List<DefdocDetailEntity> entities = this.defdocDetailMapper.queryList(condition);
        if (entities != null && entities.size() > 0) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entities.get(0)), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public DefdocDetailVO getDefDocByName(Long defDocId, String name) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        condition.put("defDocId", defDocId);
        condition.put("name", name);
        List<DefdocDetailEntity> entities = this.defdocDetailMapper.getDefDocByName(condition);
        if (entities != null && entities.size() > 0) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entities.get(0)), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public List<DefdocDetailEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<DefdocDetailEntity> resultList = this.defdocDetailMapper.queryList(condition);
        return resultList;
    }

    @Override
    public void saveDetail(DefdocDetailEntity entity) {
        this.defdocDetailMapper.saveDetail(entity);
    }

    @Override
    public void updateDetail(DefdocDetailEntity entity) {
        this.defdocDetailMapper.updateDetail(entity);
    }

    @Override
    public void insertDetailsFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.defdocDetailMapper.insertDetailsFromPlatform(tenantId);
    }
}

