package com.ejianc.foundation.init.api;

import com.ejianc.foundation.init.service.InitService;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/initDataApi/")
public class InitController {

    @Autowired
    InitService initService;

    @PostMapping("initData")
    public void initData(@RequestBody EnterpriseInitVO vo){
        initService.initData(vo);
    }

    @PostMapping("rollBack")
    public void rollBack(@RequestParam("tenantId") Long tenantId){
        initService.rollBack(tenantId);
    }
}
