/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.service.ISuplCategoryService;
import com.ejianc.foundation.supplier.service.ISuplSupplierService;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/supplierAccountApi/"})
public class SupplierAccountApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISuplSupplierService supplierService;
    @Autowired
    private ISuplCategoryService categoryService;

    @RequestMapping(value={"/sysSupplier"}, method={RequestMethod.POST})
    public CommonResponse<String> sysSupplier(@RequestBody SuplSupplierVO supplierVo) {
        this.logger.info("\u540c\u6b65\u4f9b\u65b9\u5f00\u59cb----------");
        this.supplierService.sysSupplier(supplierVo);
        this.logger.info("\u540c\u6b65\u4f9b\u65b9\u5f00\u59cb----------");
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @GetMapping(value={"/syEvaluationGrade"})
    public CommonResponse<String> syEvaluationGrade(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="evaluationGrade") Integer evaluationGrade) {
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(SupplierEntity::getEvaluationGrade, (Object)evaluationGrade);
        lambd.in(BaseEntity::getId, new Object[]{supplierId});
        this.supplierService.update((Wrapper)lambd);
        return CommonResponse.success((String)"\u540c\u6b65\u8bc4\u4ef7\u7b49\u7ea7\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getSupplierByAccessId"})
    public CommonResponse<List<SupplierVO>> getSupplierByAccessId(@RequestParam(value="accessId") Long accessId) {
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(BaseEntity::getDr, (Object)0);
        lambd.eq(SupplierEntity::getAccessId, (Object)accessId);
        List list = this.supplierService.list((Wrapper)lambd);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, SupplierVO.class));
    }

    @RequestMapping(value={"/findChildrenByParentId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Long>> findChildrenByParentId(@RequestParam(value="categoryId") Long categoryId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", this.categoryService.findChildrenByParentId(categoryId));
    }
}

