package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yqls
 * @Description:
 * @date 2021/11/11 15:03
 */
@RestController
@RequestMapping("/api/supplierWebApi/")
public class SupplierWebApi {

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IBankAccountService bankAccountService;

    @Autowired
    private IBankService bankService;

    /**
     * 查询所有供应商
     *
     * @return
     */
    @GetMapping("querySupplierList")
    CommonResponse<List<SupplierVO>> querySupplierList() {
        QueryParam queryParam = new QueryParam();
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<SupplierEntity> list = supplierService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", BeanMapper.mapList(list, SupplierVO.class));
        }
        return CommonResponse.success("查询成功！", new ArrayList<>());
    }

    /**
     * 查询所有银行账户
     *
     * @return
     */
    @GetMapping("queryBankAccountList")
    CommonResponse<List<BankAccountVO>> queryBankAccountList() {
        QueryParam queryParam = new QueryParam();
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<BankAccountEntity> list = bankAccountService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", BeanMapper.mapList(list, BankAccountVO.class));
        }
        return CommonResponse.success("查询成功！", new ArrayList<>());
    }

    /**
     * 查询所有银行档案
     *
     * @return
     */
    @GetMapping("queryBankList")
    CommonResponse<List<BankVO>> queryBankList() {
        QueryParam queryParam = new QueryParam();
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<BankEntity> list = bankService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", BeanMapper.mapList(list, BankVO.class));
        }
        return CommonResponse.success("查询成功！", new ArrayList<>());
    }

    /**
     * 根据客户id查询默认银行账户
     *
     * @return
     */
    @GetMapping("queryBankAccountByCustomerId")
    CommonResponse<BankAccountVO> queryBankAccountByCustomerId(@RequestParam("customerId") Long customerId) {
        QueryParam queryParam = new QueryParam();
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("customer_id", new Parameter(QueryParam.EQ, customerId));
        queryParam.getParams().put("default_flag", new Parameter(QueryParam.EQ, 1));
        
        List<BankAccountEntity> list = bankAccountService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", BeanMapper.mapList(list, BankAccountVO.class).get(0));
        }
        return CommonResponse.success("查询成功！", new BankAccountVO());
    }
}
