package com.ejianc.foundation.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;

public class DefdocDetailAsTree {
	
	public static List<DefdocDetailEntity> createTreeData(List<DefdocDetailEntity> list) {
		List<DefdocDetailEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, DefdocDetailEntity> listMap = new HashMap<>();
		for(DefdocDetailEntity orgEntity:list) {
			listMap.put(orgEntity.getId().toString(), orgEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	DefdocDetailEntity orgEntity = list.get(i);
        	String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
        	DefdocDetailEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<DefdocDetailEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(orgEntity);
        		}else{
        			List<DefdocDetailEntity> children = new ArrayList<DefdocDetailEntity>();
        			children.add(orgEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(orgEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	public static List<OrgVO> createTreeDataVO(List<OrgVO> list) {
		List<OrgVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, OrgVO> listMap = new HashMap<>();
		for(OrgVO orgEntity:list) {
			listMap.put(orgEntity.getId().toString(), orgEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	OrgVO orgEntity = list.get(i);
        	String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
        	OrgVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<OrgVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(orgEntity);
        		}else{
        			List<OrgVO> children = new ArrayList<OrgVO>();
        			children.add(orgEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(orgEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
