package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialMapper;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class MaterialServiceImpl implements IMaterialService {

	@Autowired
	private MaterialMapper materialMapper;
	@Autowired
	private MaterialCategoryMapper materialCategoryMapper;

	@Override
	public List<MaterialVO> queryListByCategoryId(Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> entities = materialMapper.queryListByCategoryId(tenantId, categoryId);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public MaterialVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialEntity entity = materialMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, MaterialVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialVO uniqueBean) {
		materialMapper.update(uniqueBean);
	}

	@Override
	public void save(MaterialVO materialVo) {
		materialMapper.save(materialVo);
	}

	/**
	 * 批量保存
	 *
	 * @param materialVOList
	 */
	@Override
	public void insertBatch(List<MaterialVO> materialVOList) {
		if(ListUtil.isNotEmpty(materialVOList)){
			List<MaterialVO> toInsert = new ArrayList<>();
			for (MaterialVO materialVO : materialVOList) {
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(materialVO);
			}
			if(toInsert.size()>0){
				materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}
	@Override
	public void amend(Long id,Long property,String propertyName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.amend(id,property,propertyName,tenantId);
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			materialMapper.delete(tenantId, id);
		}
	}

	@Override
	public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				MaterialCategoryEntity categoryEntity = materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
				if(categoryEntity != null) {
					condition.put("innerCode", categoryEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());

		List<MaterialEntity> records = materialMapper.queryList(condition);
		Long count = materialMapper.queryCount(condition);

		IPage<MaterialEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialVO materialVo = materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
		return materialVo;
	}

	@Override
	public List<MaterialVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialVO> list = materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
		return list;
	}

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	@Override
	public MaterialVO queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<MaterialEntity> records = materialMapper.queryExportList(condition);
		return records;
	}

	@Override
	public void insertMaterialListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.insertMaterialListFromPlatform(tenantId);
	}

	@Override
	public IPage<MaterialEntity> queryRefMaterialPage(Map<String, Object> params) {
		List<MaterialEntity> dataList = materialMapper.queryRefMaterialList(params);
		Long dataCount = materialMapper.queryRefMaterialCount(params);

		IPage<MaterialEntity> page = new Page<>();
		page.setRecords(dataList);
		page.setTotal(dataCount);
		return page;
	}

	@Override
	public MaterialEntity queryBySourceId(String sourceId) {
		return materialMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
	}

	@Override
	public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
		return materialMapper.queryMaterialByIds(ids,InvocationInfoProxy.getTenantid());
	}

	@Override
	public IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
		IPage<MaterialEntity> page = new Page<>();
		if (params.containsKey("sourceOrgId") && null !=params.get("sourceOrgId")) {
			List<MaterialEntity> dataList = materialMapper.queryZjwjRefMaterialList(params);
			Long dataCount = materialMapper.queryZjwjRefMaterialCount(params);
			page.setRecords(dataList);
			page.setTotal(dataCount);
		}
		return page;
	}

}
