package com.ejianc.foundation.support.controller;

import java.sql.BatchUpdateException;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.JedisCacheTool;

import cn.hutool.json.JSONArray;

/**
 * 数据传输Controller
 * 
 * @author xg
 * @date 2018-05-09
 */
@Controller
@RequestMapping(value = "dataTransfer")
public class DataTransferController {

	private static final Logger LOGGER = LoggerFactory.getLogger(DataTransferController.class);

	@Autowired
	private IDataTransferService service;

	/**
	 * 执行sql同步数据
	 * 
	 * @param params
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "transferBySql")
	public CommonResponse<String> transferBySql(@RequestBody Map<String, Object> params) {
		try {
			if (params == null || params.isEmpty() || params.get("sql") == null) {
				return CommonResponse.error("发布数据失败:缺少必要参数!");
			}
			LOGGER.info("接收到发布的数据参数：{}", JSONObject.toJSONString(params));
			List<String> sqls = (List<String>) params.get("sql");
			if (sqls != null&&sqls.size()>0) {
				service.executeSql(sqls);
			}
		} catch (DuplicateKeyException dke) {
			String errorMsg = dke.getMessage();
			if (dke.getCause() != null) {
				LOGGER.error(dke.getMessage(), dke.getCause());
				BatchUpdateException bue = (BatchUpdateException) dke.getCause();
				if ("23000".equalsIgnoreCase(bue.getSQLState())) { // 违反唯一性索引约束
					String msg = bue.getMessage();
					String code = msg.substring(msg.indexOf("'") + 1, msg.indexOf("for") - 2);
					if (StringUtils.isNotBlank(code) && code.contains("-")) {
						code = code.substring(0, code.lastIndexOf("-"));
					}
					errorMsg = "目标环境已存在编号为[" + code + "]的数据";
				}
			}
			return CommonResponse.error("发布数据失败:" + errorMsg);
		} catch (Exception e) {
			e.printStackTrace();
			LOGGER.error(e.getMessage(), e.getCause());
			return CommonResponse.error("发布数据失败:" + e.getMessage());
		}
		return CommonResponse.success("发布数据成功");
	}
}
