package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 供方
 *
 * @author guoming
 *
 */
@TableName("ejc_support_supplier")
public class SupplierEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "code")
	private String code; // 供方编码

	@TableField(value = "name")
	private String name; // 供方名称

	@TableField(value = "category_id")
	private Long categoryId; // 供方分类ID

	@TableField(value = "category_name")
	private String categoryName; // 供方分类名称

	@TableField(value = "social_credit_code")
	private String socialCreditCode; // 社会信用代码

	@TableField(value = "legal")
	private String legal; // 法定代表人

	@TableField(value = "tax_payer_type")
	private Long taxPayerType; // 纳税人类型

	@TableField(value = "business_scope")
	private String businessScope; // 经营范围

	@TableField(value = "enabled")
	private Integer enabled; // 合作不合作（1：合作 ， 0：不合作）

	@TableField(value = "area")
	private String area; // 地区

	@TableField(value = "address")
	private String address; // 详细地址

	@TableField(value = "telephone")
	private String telephone; // 客户电话

	@TableField(value = "bank_name")
	private String bankName; // 账户名

	@TableField(value = "bank_account")
	private String bankAccount;// 银行账号

	@TableField(value = "bank_code")
	private String bankCode; // 开户行

	@TableField(value = "description")
	private String description; // 描述

	@TableField(value = "source_id")
	private String sourceId; // 来源id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "tenant")
	private Long tenant; // 关联租户id（供方协同）

	@TableField(value = "tenant_name")
	private String tenantName; // 关联租户名称（供方协同）

	@TableField(value = "tenant_phone")
	private String tenantPhone; // 生成租户手机号（供方协同）

	@TableField(value = "tenant_user_name")
	private String tenantUserName; // 生成租户管理员名称（供方协同）

	/**
	 * 省份
	 */
	@TableField(value = "province")
	private String province;

	/**
	 * 市区
	 */
	@TableField(value = "city")
	private String city;

	/**
	 * 区县
	 */
	@TableField(value = "region")
	private String region;

	@TableField(value = "org_id")
	private Long orgId; // 所属组织ID

	@TableField(value = "inside_org_id")
	private Long insideOrgId; // 内部客商--来源组织id(青岛市政）
	@TableField(value = "org_name")
	private String orgName; // 所属组织

	@TableField(value = "enterprise_nature")
	private Long enterpriseNature; // 企业性质
	@TableField(value = "register_time")
	private java.util.Date registerTime; // 注册日期
	@TableField(value = "tax_payer_identifier")
	private String taxPayerIdentifier; // 纳税人识别号
	@TableField(value = "registered_capital")
	private BigDecimal registeredCapital; // 注册资金
	@TableField(value = "legal_phone")
	private String legalPhone; // 法人电话
	@TableField(value = "issuing_time")
	private java.util.Date issuingTime; // 发证时间
	@TableField(value = "evaluation_grade")
	private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
	@TableField(value = "supplier_flag")
	private Integer supplierFlag; // 是否属于物资，0-否，1-是
	@TableField(value = "sub_flag")
	private Integer subFlag; // 是否属于分包，0-否，1-是
	@TableField(value = "blacklist_flag")
	private Integer blacklistFlag; // 是否黑名单，0-否，1-是
	@TableField(value = "redlist_flag")
	private Integer redlistFlag; // 是否红名单，0-否，1-是
	@TableField(value = "operate_id")
	private Long operateId; // 操作人id
	@TableField(value = "operate_name")
	private String operateName; // 操作人名称
	@TableField(value = "operate_time")
	private java.util.Date operateTime; // 操作时间
	@TableField(value = "operate_org_id")
	private Long operateOrgId; // 操作人所属组织id
	@TableField(value = "operate_org_name")
	private String operateOrgName; // 操作人所属组织名称
	@TableField(value = "bl_time")
	private java.util.Date blTime; // 营业执照有效期
	@TableField(value = "spl_time")
	private java.util.Date splTime; // 安全生产许可证有效期
	@TableField(value = "qc_time")
	private java.util.Date qcTime; // 资质证书有效期
	@TableField(value = "sc_time")
	private java.util.Date scTime; // 安全证有效期
	// 证件类型：lppoa-法人委托授权书，lpidc-法人身份复印件，bl-营业执照，spl-安全生产许可证，qc-资质证书，sc-安全证，other-其他证件
	@TableField(value="access_id")
	private Long accessId; // 供应商准入id

	public Long getAccessId() {
		return accessId;
	}

	public void setAccessId(Long accessId) {
		this.accessId = accessId;
	}

	public Integer getRedlistFlag() {
		return redlistFlag;
	}

	public void setRedlistFlag(Integer redlistFlag) {
		this.redlistFlag = redlistFlag;
	}

	public Date getBlTime() {
		return blTime;
	}

	public void setBlTime(Date blTime) {
		this.blTime = blTime;
	}

	public Date getSplTime() {
		return splTime;
	}

	public void setSplTime(Date splTime) {
		this.splTime = splTime;
	}

	public Date getQcTime() {
		return qcTime;
	}

	public void setQcTime(Date qcTime) {
		this.qcTime = qcTime;
	}

	public Date getScTime() {
		return scTime;
	}

	public void setScTime(Date scTime) {
		this.scTime = scTime;
	}

	public Long getEnterpriseNature() {
		return enterpriseNature;
	}

	public void setEnterpriseNature(Long enterpriseNature) {
		this.enterpriseNature = enterpriseNature;
	}

	public Date getRegisterTime() {
		return registerTime;
	}

	public void setRegisterTime(Date registerTime) {
		this.registerTime = registerTime;
	}

	public String getTaxPayerIdentifier() {
		return taxPayerIdentifier;
	}

	public void setTaxPayerIdentifier(String taxPayerIdentifier) {
		this.taxPayerIdentifier = taxPayerIdentifier;
	}

	public BigDecimal getRegisteredCapital() {
		return registeredCapital;
	}

	public void setRegisteredCapital(BigDecimal registeredCapital) {
		this.registeredCapital = registeredCapital;
	}

	public String getLegalPhone() {
		return legalPhone;
	}

	public void setLegalPhone(String legalPhone) {
		this.legalPhone = legalPhone;
	}

	public Date getIssuingTime() {
		return issuingTime;
	}

	public void setIssuingTime(Date issuingTime) {
		this.issuingTime = issuingTime;
	}

	public Integer getEvaluationGrade() {
		return evaluationGrade;
	}

	public void setEvaluationGrade(Integer evaluationGrade) {
		this.evaluationGrade = evaluationGrade;
	}

	public Integer getSupplierFlag() {
		return supplierFlag;
	}

	public void setSupplierFlag(Integer supplierFlag) {
		this.supplierFlag = supplierFlag;
	}

	public Integer getSubFlag() {
		return subFlag;
	}

	public void setSubFlag(Integer subFlag) {
		this.subFlag = subFlag;
	}

	public Integer getBlacklistFlag() {
		return blacklistFlag;
	}

	public void setBlacklistFlag(Integer blacklistFlag) {
		this.blacklistFlag = blacklistFlag;
	}

	public Long getOperateId() {
		return operateId;
	}

	public void setOperateId(Long operateId) {
		this.operateId = operateId;
	}

	public String getOperateName() {
		return operateName;
	}

	public void setOperateName(String operateName) {
		this.operateName = operateName;
	}

	public Date getOperateTime() {
		return operateTime;
	}

	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public Long getOperateOrgId() {
		return operateOrgId;
	}

	public void setOperateOrgId(Long operateOrgId) {
		this.operateOrgId = operateOrgId;
	}

	public String getOperateOrgName() {
		return operateOrgName;
	}

	public void setOperateOrgName(String operateOrgName) {
		this.operateOrgName = operateOrgName;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public Long getTaxPayerType() {
		return taxPayerType;
	}

	public void setTaxPayerType(Long taxPayerType) {
		this.taxPayerType = taxPayerType;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public Long getTenant() {
		return tenant;
	}

	public void setTenant(Long tenant) {
		this.tenant = tenant;
	}

	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public String getTenantPhone() {
		return tenantPhone;
	}

	public void setTenantPhone(String tenantPhone) {
		this.tenantPhone = tenantPhone;
	}

	public String getTenantUserName() {
		return tenantUserName;
	}

	public void setTenantUserName(String tenantUserName) {
		this.tenantUserName = tenantUserName;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getInsideOrgId() {
		return insideOrgId;
	}

	public void setInsideOrgId(Long insideOrgId) {
		this.insideOrgId = insideOrgId;
	}

}
