package com.ejianc.foundation.support.service;

import java.util.List;

import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IModuleService extends IBaseService<ModuleEntity> {

	/**
	 * 根据主键ID查询实体
	 * 
	 * @param id
	 * @return
	 */
	ModuleEntity queryDetail(Long id);

	/**
	 * 根据父Id查询其子节点list
	 * 
	 * @param id
	 * @return
	 */
	List<ModuleEntity> queryListByPid(Long id);

	/**
	 * 根据主键删除实体
	 * 
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 根据父节点ID查询其下所有子节点(包含孙子...)
	 * 
	 * @param moduleId
	 * @return
	 */
	List<ModuleVO> queryAllChildrenByPid(Long moduleId);

}
