package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankCategoryVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 银行档案实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("bank")
public class BankController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;



    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String BILL_CODE = "SUPPORT_BANK_CODE";//此处需要根据实际修改
    private static final String BANK_BILL_TYPE_CODE = "BT211026000000001";
    
    @Autowired
    private IBankService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankVO> saveOrUpdate(@RequestBody BankVO saveorUpdateVO) {
    	BankEntity entity = BeanMapper.map(saveorUpdateVO, BankEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setEnabled(1);
        }
    	service.saveOrUpdate(entity, false);
    	BankVO vo = BeanMapper.map(entity, BankVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankVO> queryDetail(Long id) {
    	BankEntity entity = service.selectById(id);
    	BankVO vo = BeanMapper.map(entity, BankVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if (res.isSuccess()){
            return CommonResponse.success();
        }else {
            return CommonResponse.error(res.getMsg());
        }
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BankCategoryVO> vos) {
        for (BankCategoryVO vo : vos){
            CommonResponse<String> res = billTypeApi.checkQuote(BANK_BILL_TYPE_CODE,vo.getId());
            logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
            if (!res.isSuccess()){
                throw new BusinessException("删除失败！该银行信息已存在银行账户信息，不允许删除");
            }
        }
        service.removeByIds(vos.stream().map(BankCategoryVO::getId).collect(Collectors.toList()),true);
        return  CommonResponse.success("删除成功");
    }


    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/enabled/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody BankVO bankVo) {
        service.updateEnabled(bankVo);
        return CommonResponse.success("更新成功");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BankEntity> page = service.queryPage(param,false);
        IPage<BankVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bank-export.xlsx", "银行列表档案导出模板");
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<BankVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBankData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BankVO>> refBankData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                     @RequestParam(required=false) String relyCondition,
                                                     @RequestParam(required=false) String searchText,
                                                     @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        if(StringUtils.isNotBlank(relyCondition)) {
            Long bankCategoryId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("bankCategoryId",new Parameter(QueryParam.EQ,bankCategoryId));
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));

        IPage<BankEntity> page = service.queryPage(param,false);
        IPage<BankVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
