package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/param/config/")
public class ParamConfigApi {

	@Autowired
	private IParamRegisterSetService iParamRegisterSetService;

	@Autowired
	private IBillParamService billParamService;
	@Autowired
	private IBillParamCustomService billParamCustomService;

	@RequestMapping(value = "getByCode", method=RequestMethod.GET)
	public CommonResponse<ParamRegisterSetVO> getByCode(@RequestParam(value="code") String code) {
		ParamRegisterSetEntity entity = iParamRegisterSetService.getByCode(code);
		if(entity == null){
			return CommonResponse.error("该参数尚未配置！");
		}
		ParamRegisterSetVO vo = BeanMapper.map(entity,ParamRegisterSetVO.class);
		return CommonResponse.success(vo);
	}

	@RequestMapping(value = "getBillParamByCode", method=RequestMethod.GET)
	public CommonResponse<BillParamVO> getBillParamByCode(@RequestParam(value="code") String code) {
		QueryParam param = new QueryParam();
		param.getParams().put("code", new Parameter(QueryParam.EQ, code));
		List<BillParamEntity> setEntities = billParamService.queryList(param,false);
		if(ListUtil.isNotEmpty(setEntities)){
			param = new QueryParam();
			BillParamEntity billParamEntity = setEntities.get(0);
			param.getParams().put("pid", new Parameter(QueryParam.EQ, billParamEntity.getId()));
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			List<BillParamCustomEntity> sutEntities = billParamCustomService.queryList(param,false);
			if(ListUtil.isNotEmpty(sutEntities)){
				BillParamCustomEntity customEntity = sutEntities.get(0);
				billParamEntity.setControlType(customEntity.getControlType());
				billParamEntity.setRoleValue(customEntity.getRoleValue());
			}
		}else {
			return CommonResponse.error("该参数未发布或者没有定义！");
		}
		BillParamVO vo = BeanMapper.map(setEntities.get(0),BillParamVO.class);
		return CommonResponse.success(vo);
	}
}
