package com.ejianc.foundation.support.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface DefdocDetailMapper extends BaseCrudMapper<DefdocDetailEntity> {

	void updateEnabled(@Param("enabled") Integer enabled, @Param("tenantId") Long tenantId,@Param("innerCode") String innerCode);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4  根据租户id分表查询某个自定义档案详情数据
	 * @Description queryList
	 * @Param [condition]
	 * @Return java.util.List<com.ejianc.foundation.support.bean.DefdocDetailEntity>
	 */
	List<DefdocDetailEntity> queryList(Map<String, Object> condition);
	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4  根据租户id分表查询某个自定义档案详情数据
	 * @Description queryList
	 * @Param [condition]
	 * @Return java.util.List<com.ejianc.foundation.support.bean.DefdocDetailEntity>
	 */
	List<DefdocDetailEntity> getDefDocByName(Map<String, Object> condition);
	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4  根据租户id分表查询某个自定义档案详情数据
	 * @Description queryList
	 * @Param [condition]
	 * @Return java.util.List<com.ejianc.foundation.support.bean.DefdocDetailEntity>
	 */
	List<DefdocDetailEntity> getDefDocByDefId(@Param("defId") Long defId,@Param("tenantId") Long tenantId);

	void saveDetail(DefdocDetailEntity entity);

	void updateDetail(DefdocDetailEntity entity);

	
	DefdocDetailEntity queryDetail(@Param("id") Long id,@Param("tenantId") Long tenantId);

	List<DefdocDetailEntity> queryListByPid(@Param("parentId") Long parentId,@Param("tenantId") Long tenantId);

	void deleteBean(@Param("id") Long id,@Param("tenantId") Long tenantId);

	List<DefdocDetailEntity> queryListByDefdocId(@Param("ids") String ids, @Param("tenantId") Long tenantId);

	void insertDetailsFromPlatform(@Param("tenantId") Long tenantId);

}
