package com.ejianc.foundation.support.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface ModuleMapper extends BaseCrudMapper<ModuleEntity> {

    /**
     * 查询匹配条件的模块列表
     *
     * @param queryParam
     * @return
     */
    List<ModuleVO> getListByProperties(Map<String, Object> queryParam);

    /**
     * 根据条件查询匹配的模块的内码
     *
     * @param queryParam
     * @return
     */
    List<String> getInnerCodeByProperties(Map<String, Object> queryParam);

    /**
     * 查询条件匹配的模块树
     *
     * @param queryParam
     * @return
     */
    List<ModuleVO> getAllParentByPeroperties(Map<String, Object> queryParam);

    /**
     * 获取指定模块组下的最大内码
     *
     * @param param
     * @return
     */
    String getMaxInnercode(Map<String, Object> param);
}
