package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/materialApi/")
public class MaterialApi {

    @Autowired
    private IMaterialService materialService;
	@Autowired
	private IMaterialCategoryService materialCategoryService;

    @PostMapping("queryExitFlag")
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
    	MaterialVO vo = materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
    	return CommonResponse.success("查询成功！", vo);
    }
    @PostMapping("queryExcelFlag")
    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = materialService.queryExcelFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryName());
        return CommonResponse.success("查询成功！", list);
    }

    @PostMapping("queryMaterialFlag")
    public CommonResponse<List<MaterialVO>> queryMaterialFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = materialService.queryMaterialFlag(materialVO.getName(), materialVO.getSpec());
        return CommonResponse.success("查询成功！", list);
    }
    
    @GetMapping("queryCategoryByCode")
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code) {
        List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if(ListUtil.isNotEmpty(list)){
            vo = BeanMapper.map(list.get(0),MaterialCategoryVO.class);
        }
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码所属分类！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryCategoryListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id) {
    	List<MaterialCategoryVO> list = materialCategoryService.queryListByPid(id);
    	return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryListByChildren")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success("查询成功！", list);
    }

    @PostMapping("queryCategoryListByPost")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPost(@RequestBody List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/10/19 根据sourceId查询物资
     * @Description queryMaterialBySourceId
     * @Param [sourceId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
     */
    @GetMapping("queryMaterialBySourceId")
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = materialService.queryBySourceId(sourceId);
        if(entity!=null){
            return CommonResponse.success(BeanMapper.map(entity,MaterialVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
    }

	/**
	 * @Author liyj
	 * @Date 2020/10/29 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 * @Param [ids]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "queryMaterialByIds")
	CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids){
		List<MaterialEntity> entitys = materialService.queryMaterialByIds(ids);
        if(entitys!=null&&entitys.size()>0){
            return CommonResponse.success(BeanMapper.mapList(entitys,MaterialVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
	};

    /**
     * 根据主键查询物料分类详情
     * @Author zhangwx
     * @param id
     * @return
     */
    @GetMapping("queryCategoryById")
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("查询成功！", materialCategoryService.queryDetail(id));
    }
}
