package com.ejianc.foundation.billcode.engine;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

@Component
public class BillcodeSNReferProducer {
    @Autowired
    private JedisPool jedisPool;

    public void sendQueue(BillCodeSNVO billcodesnVO) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.lpush(BillcodeSNReferQueue.MESSAGE_KEY, JSON.toJSONString(billcodesnVO));

        } catch (JedisException e) {
            throw new JedisException(e);
        } finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }
}
