/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/supplier/"})
public class SupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private ISupplierLinkerService supplierLinkerService;
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private IBillTypeService billTypeService;
    @Autowired
    private IBankAccountService bankAccountService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if (supplierVo.getCategoryId() == null) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse<SupplierVO> response = this.supplierService.saveOrUpdate(supplierVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(@RequestParam Long id) {
        SupplierVO supplierVo = this.supplierService.queryDetail(id);
        JSONObject parent = new JSONObject();
        SupplierCategoryEntity e = (SupplierCategoryEntity)((Object)this.supplierCategoryService.selectById(supplierVo.getCategoryId()));
        parent.put("id", (Object)e.getId());
        parent.put("code", (Object)e.getCode());
        parent.put("name", (Object)e.getName());
        supplierVo.setParent(parent);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            this.bankAccountService.delBySuppAndCustomIds("supplierId", ids);
            for (Long id : ids) {
                CommonResponse<String> response = this.billTypeService.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<SupplierVO> pageData = this.supplierService.queryPageList(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"supplier-import.xlsx", (String)"\u4f9b\u65b9\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantId = InvocationInfoProxy.getTenantid();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        ArrayList<String> errorList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                SupplierVO supplierVo = null;
                SupplierCategoryVO supplierCategoryVo = this.supplierCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (supplierCategoryVo != null) {
                    DefdocDetailVO taxPayerTypeVo;
                    if (StringUtils.isEmpty((CharSequence)datas.get(2))) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    supplierVo = this.supplierService.queryDetailBySocialCode(String.valueOf(datas.get(2)));
                    if (supplierVo != null) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u76f8\u540c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7684\u4f9b\u5e94\u5546\uff01");
                        continue;
                    }
                    supplierVo = new SupplierVO();
                    try {
                        String billCode = this.generator.generateBillCodeById(SUPPLIER_BILL_CODE, tenantId);
                        supplierVo.setCode(billCode);
                    }
                    catch (BillCodeException e) {
                        supplierVo.setCode(String.valueOf(new Date().getTime()));
                    }
                    if (StringUtils.isEmpty((CharSequence)datas.get(1))) {
                        errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    supplierVo.setName(String.valueOf(datas.get(1)));
                    supplierVo.setCategoryId(supplierCategoryVo.getId());
                    supplierVo.setSocialCreditCode(String.valueOf(datas.get(2)));
                    supplierVo.setLegal(String.valueOf(datas.get(3)));
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(4)) && (taxPayerTypeVo = this.defdocDetailService.queryDetailByName(String.valueOf(datas.get(4)))) != null) {
                        supplierVo.setTaxPayerType(taxPayerTypeVo.getId());
                    }
                    supplierVo.setBusinessScope(datas.get(5));
                    supplierVo.setTelephone(datas.get(6));
                    supplierVo.setArea(datas.get(7));
                    supplierVo.setAddress(datas.get(8));
                    supplierVo.setBankName(datas.get(9));
                    supplierVo.setBankAccount(datas.get(10));
                    supplierVo.setBankCode(datas.get(11));
                    if (StringUtils.isNotEmpty((CharSequence)datas.get(12))) {
                        ArrayList<SupplierLinkerVO> gridheaders = new ArrayList<SupplierLinkerVO>();
                        String linkman = String.valueOf(datas.get(12));
                        SupplierLinkerVO supplierLinkerVo = this.supplierLinkerService.queryBySupplierIdAndLinkman(supplierVo.getId(), linkman);
                        if (supplierLinkerVo == null) {
                            supplierLinkerVo = new SupplierLinkerVO();
                            supplierLinkerVo.setRowState("add");
                        } else {
                            supplierLinkerVo.setRowState("edit");
                        }
                        supplierLinkerVo.setSupplierId(supplierVo.getId());
                        supplierLinkerVo.setLinkman(datas.get(12));
                        supplierLinkerVo.setCellphone(datas.get(13));
                        gridheaders.add(supplierLinkerVo);
                        supplierVo.setGridheaders(gridheaders);
                    }
                    supplierVo.setEnabled(Integer.valueOf(1));
                    this.supplierService.saveOrUpdate(supplierVo);
                    continue;
                }
                errorList.add("\u7b2c" + i + "\u884c\u6570\u636e\uff1a" + datas.toString() + "\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4f9b\u65b9\u5206\u7c7b\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
            }
        }
        if (errorList.size() > 0) {
            errorList.add("\u5bfc\u5165\u6210\u529f\uff1a" + (result.size() - errorList.size() - 1) + "\u6761, \u5931\u8d25\uff1a" + errorList.size() + "\u6761");
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25", errorList);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<Object> supplierVos = new ArrayList();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        supplierVos = this.supplierService.queryExportList(queryParam);
        HashMap beans = new HashMap();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("supplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"refSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.supplierCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", supplierCategoryEntity.getInnerCode());
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "outside");
        params.put("enabled", 1);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("currentState", 1);
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"refSupplierPageNew"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPageNew(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.supplierCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", supplierCategoryEntity.getInnerCode());
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "outside");
        params.put("enabled", 1);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"refInsideSupplierPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refInsideSupplierPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Long categoryId;
        SupplierCategoryEntity supplierCategoryEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (supplierCategoryEntity = this.supplierCategoryService.queryDetail(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1])))) != null) {
            params.put("innerCode", supplierCategoryEntity.getInnerCode());
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("range", "inside");
        params.put("enabled", 1);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<SupplierVO> pageData = this.supplierService.queryRefMaterialPage(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/enableSupplierOrNot"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enableSupplierOrNot(@RequestBody Map<String, Object> data) {
        if (data == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u5904\u7406\u7684\u6570\u636e\uff01");
        }
        List ids = (List)data.get("ids");
        String state = (String)data.get("state");
        if (ListUtil.isEmpty((List)ids) || StringUtils.isEmpty((CharSequence)state)) {
            return CommonResponse.error((String)"\u6ca1\u6709\u53ef\u5904\u7406\u7684\u6570\u636e\uff01");
        }
        if (!state.equals("0") && !state.equals("1")) {
            return CommonResponse.error((String)"\u5408\u4f5c\u72b6\u6001\u4e0d\u6b63\u786e\uff01");
        }
        data.put("tenantId", InvocationInfoProxy.getTenantid());
        data.put("ids", StringUtils.join((Object[])ids.toArray(), (String)","));
        this.supplierService.enableSupplierOrNot(data);
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/supplierCollaboration"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> supplierCollaboration(@RequestBody SupplierVO supplierVO) {
        return this.supplierService.supplierCollaboration(supplierVO);
    }

    @RequestMapping(value={"/querySupplierByTenantId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByTenantId(@RequestParam Long tenant) {
        SupplierVO supplierVo = this.supplierService.querySupplierByTenantId(tenant);
        return CommonResponse.success((Object)supplierVo);
    }

    @RequestMapping(value={"/querySupplierByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierByCode(@RequestParam String code) {
        SupplierVO supplierVo = new SupplierVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.success(null);
    }

    @RequestMapping(value={"/querySupplierBySourceId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierBySourceId(@RequestParam String sourceId) {
        SupplierVO supplierVo = new SupplierVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"enabled", (Object)1);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546");
    }

    @RequestMapping(value={"/generateInsideSupplierAndCustomer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> generateInsideSupplierAndCustomer(@RequestBody List<OrgVO> orgList) {
        return this.supplierService.generateInsideSupplierAndCustomer(orgList);
    }
}

