package com.ejianc.foundation.support.service.impl;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.ParamRegisterSetMapper;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IParamRegisterSetService;

import java.util.List;

/**
 * 参数设置
 * 
 * @author generator
 * 
 */
@Service("paramRegisterSetService")
public class ParamRegisterSetServiceImpl extends BaseServiceImpl<ParamRegisterSetMapper, ParamRegisterSetEntity> implements IParamRegisterSetService{

    @Override
    public ParamRegisterSetEntity getByCode(String code) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("code", new Parameter(QueryParam.EQ, code));
        List<ParamRegisterSetEntity> setEntities =  queryList(param,false);
        if(ListUtil.isEmpty(setEntities)){
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, 999999));
            setEntities = queryList(param,false);
            if(ListUtil.isEmpty(setEntities)){
                return null;
            }
        }
        return setEntities.get(0);
    }
}
