package com.ejianc.foundation.support.service.impl;

import java.util.*;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.DefdocDetailTenantRelationEntity;
import com.ejianc.foundation.support.service.IDefdocDetailTenantRelationService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.mapper.DefdocDetailMapper;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@Service
public class DefdocDetailServiceImpl extends BaseServiceImpl<DefdocDetailMapper, DefdocDetailEntity> implements IDefdocDetailService {

	@Autowired
	private DefdocDetailMapper defdocDetailMapper;

	@Autowired
	private IDefdocDetailTenantRelationService detailTenantRelationService;

	@Value("${oms.tenantid}")
	private String OMS_TENANT;

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4 判断操作租户是否是平台运营租户
	 * @Description isOmsTenant
	 * @Param []
	 * @Return boolean true 平台运营租户，false 其他租户
	 */
	private boolean isOmsTenant(){
		Long tenantId = InvocationInfoProxy.getTenantid();
		return OMS_TENANT.equals(tenantId.toString());
	}
	/**
	 * @Author mrsir_wxp
	 * @Date 2020/6/4 根据自定义档案id,查询所有自定义档案项
	 * @Description queryListByDefdocId
	 * @Param [ids]
	 * @Return java.util.List<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@Override
	public List<DefdocDetailVO> queryListByDefdocId(List<Long> ids) {
		StringBuffer buffer = new StringBuffer();
		if (ids.size() > 0) {
			for (int i = 0; i < ids.size(); i++) {
				buffer.append(ids.get(i));
				if (i < (ids.size() - 1)) {
					buffer.append(",");
				}
			}
		}
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<DefdocDetailEntity> entity = defdocDetailMapper.queryListByDefdocId(buffer.toString(), tenantId);
		if (entity != null) {
			return BeanMapper.mapList(entity, DefdocDetailVO.class);
		}

		return null;
	}

	/**
	 * 根据 自定义档案id 查询自定义档案项
	 *
	 * @param defId
	 * @return
	 */
	@Override
	public List<DefdocDetailVO> getDefDocByDefId(Long defId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<DefdocDetailEntity> list = defdocDetailMapper.getDefDocByDefId(defId, tenantId);
		if (list != null) {
			return BeanMapper.mapList(list, DefdocDetailVO.class);
		}

		return null;
	}
	/**
	 * 根据 自定义档案id 查询自定义档案项
	 *
	 * @param defId
	 * @return
	 */
	@Override
	public List<DefdocDetailVO> getDefDocByDefId(Long defId,Long tenantId) {
		List<DefdocDetailEntity> list = defdocDetailMapper.getDefDocByDefId(defId,tenantId);
		if (list != null) {
			return BeanMapper.mapList(list, DefdocDetailVO.class);
		}

		return null;
	}

	@Override
	public DefdocDetailVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		DefdocDetailEntity entity = defdocDetailMapper.queryDetail(id, tenantId);
		if(entity != null) {
			return BeanMapper.map(entity, DefdocDetailVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		DefdocDetailVO vo = queryDetail(id);
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(!tenantId.toString().equals(OMS_TENANT) && vo.getTenantId().toString().equals(OMS_TENANT)){
			//当前租户不是平台租户且当前租户要删除平台档案
			DefdocDetailTenantRelationEntity relationEntity = BeanMapper.map(vo, DefdocDetailTenantRelationEntity.class);
			relationEntity.setDetailId(relationEntity.getId());
			relationEntity.setId(null);
			relationEntity.setTenantId(null);
			relationEntity.setCreateTime(null);
			relationEntity.setCreateUserCode(null);
			relationEntity.setUpdateTime(null);
			relationEntity.setUpdateUserCode(null);
			relationEntity.setDr(0);
			relationEntity.setDel(1);
//			defdocDetailMapper.saveDetail(relationEntity);
			detailTenantRelationService.saveOrUpdate(relationEntity, false);
		}else if(!tenantId.toString().equals(OMS_TENANT) && tenantId.equals(vo.getTenantId())){
			//删除的是用户自己的数据
			QueryWrapper<DefdocDetailEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			wrapper.eq("id", vo.getId());
			wrapper.eq("dr", 0);
			List<DefdocDetailEntity> list = this.list(wrapper);
			if(list!=null && list.size()>0){
				//删除的是用户自己建的
				this.removeById(vo.getId(), false);
			}else{
				//删除是原先平台档案但是后来修改过的
				DefdocDetailTenantRelationEntity relationEntity = BeanMapper.map(vo, DefdocDetailTenantRelationEntity.class);
				relationEntity.setDetailId(relationEntity.getId());
				relationEntity.setTenantId(tenantId);
				relationEntity.setUpdateTime(new Date());
				relationEntity.setUpdateUserCode(InvocationInfoProxy.getUsercode());
				defdocDetailMapper.delteDetail(relationEntity);
			}
		}else{
			//平台数据删除
			this.removeById(vo.getId(), false);
		}
	}

	@Override
	public List<DefdocDetailVO> queryListByPid(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<DefdocDetailEntity> entityList = defdocDetailMapper.queryListByPid(id, tenantId);
		if (entityList != null) {
			return BeanMapper.mapList(entityList, DefdocDetailVO.class);
		}
		return null;
	}

	@Override
	public void updateEnabled(DefdocDetailVO defdocDetailVo) {
		DefdocDetailVO vo = queryDetail(defdocDetailVo.getId());
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(!tenantId.toString().equals(OMS_TENANT) && vo.getTenantId().toString().equals(OMS_TENANT)){
			//当前数据租户不是平台租户且当前租户要启停用平台档案--关系表新增一条修改记录
			DefdocDetailTenantRelationEntity relationEntity = BeanMapper.map(vo, DefdocDetailTenantRelationEntity.class);
			relationEntity.setDetailId(relationEntity.getId());
			relationEntity.setId(null);
			relationEntity.setTenantId(null);
			relationEntity.setCreateTime(null);
			relationEntity.setCreateUserCode(null);
			relationEntity.setUpdateTime(null);
			relationEntity.setUpdateUserCode(null);
			relationEntity.setDel(0);
			relationEntity.setEnabled(defdocDetailVo.getEnabled());
			detailTenantRelationService.saveOrUpdate(relationEntity, false);
		}else if(!tenantId.toString().equals(OMS_TENANT) && tenantId.equals(vo.getTenantId())){
			//修改的是用户自己的数据
			QueryWrapper<DefdocDetailEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			wrapper.eq("id", vo.getId());
			wrapper.eq("dr", 0);
			List<DefdocDetailEntity> list = this.list(wrapper);
			if(list!=null && list.size()>0){
				//启停用的是用户自己建的
				DefdocDetailEntity entity = this.selectById(defdocDetailVo.getId());
				entity.setEnabled(defdocDetailVo.getEnabled());
				this.saveOrUpdate(entity, false);
			}else{
				//启停用是原先平台档案但是后来修改过的
				QueryWrapper<DefdocDetailTenantRelationEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("dr", 0);
				queryWrapper.eq("tenant_id", tenantId);
				queryWrapper.eq("detail_id", defdocDetailVo.getId());
				DefdocDetailTenantRelationEntity relationEntity = detailTenantRelationService.getOne(queryWrapper);
				relationEntity.setEnabled(defdocDetailVo.getEnabled());
				detailTenantRelationService.saveOrUpdate(relationEntity, false);
			}
		}else{
			//平台数据启停用
			DefdocDetailEntity entity = this.selectById(defdocDetailVo.getId());
			entity.setEnabled(defdocDetailVo.getEnabled());
			this.saveOrUpdate(entity, false);
		}
	}

	@Override
	public DefdocDetailVO queryDetailByName(String name) {
		Map<String, Object> condition = new HashMap<>();
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		condition.put("name", name);
		List<DefdocDetailEntity> entities = defdocDetailMapper.queryList(condition);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), DefdocDetailVO.class);
		}
		return null;
	}

	/**
	 * 根据自定义档案名称查询自定义档案
	 *
	 * @param defDocId
	 * @param name
	 * @return
	 */
	@Override
	public DefdocDetailVO getDefDocByName(Long defDocId, String name) {
		Map<String, Object> condition = new HashMap<>();
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		condition.put("defDocId", defDocId);
		condition.put("name", name);
		List<DefdocDetailEntity> entities = defdocDetailMapper.getDefDocByName(condition);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), DefdocDetailVO.class);
		}
		return null;
	}

	@Override
	public List<DefdocDetailEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<DefdocDetailEntity> resultList = defdocDetailMapper.queryList(condition);
		return resultList;
	}

	@Override
	public void saveDetail(DefdocDetailEntity entity) {
		this.saveOrUpdate(entity, false);
	}

	@Override
	public void updateDetail(DefdocDetailEntity entity) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(!tenantId.toString().equals(OMS_TENANT) && entity.getTenantId().toString().equals(OMS_TENANT)){
			//当前数据租户不是平台租户且当前租户要启停用平台档案--关系表新增一条修改记录
			DefdocDetailTenantRelationEntity relationEntity = BeanMapper.map(entity, DefdocDetailTenantRelationEntity.class);
			relationEntity.setDetailId(relationEntity.getId());
			relationEntity.setId(null);
			relationEntity.setTenantId(null);
			relationEntity.setCreateTime(null);
			relationEntity.setCreateUserCode(null);
			relationEntity.setUpdateTime(null);
			relationEntity.setDel(0);
			relationEntity.setUpdateUserCode(null);
			detailTenantRelationService.saveOrUpdate(relationEntity, false);
		}else if(!tenantId.toString().equals(OMS_TENANT) && tenantId.equals(entity.getTenantId())){
			//修改的是用户自己的数据
			QueryWrapper<DefdocDetailEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			wrapper.eq("id", entity.getId());
			wrapper.eq("dr", 0);
			List<DefdocDetailEntity> list = this.list(wrapper);
			if(list!=null && list.size()>0){
				//启停用的是用户自己建的
				this.saveOrUpdate(entity, false);
			}else{
				//启停用是原先平台档案但是后来修改过的
				QueryWrapper<DefdocDetailTenantRelationEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("dr", 0);
				queryWrapper.eq("tenant_id", tenantId);
				queryWrapper.eq("detail_id", entity.getId());
				DefdocDetailTenantRelationEntity relationEntity = detailTenantRelationService.getOne(queryWrapper);
				relationEntity.setEnabled(entity.getEnabled());
				relationEntity.setName(entity.getName());
				relationEntity.setCode(entity.getCode());
				relationEntity.setDescription(entity.getDescription());
				relationEntity.setSequence(entity.getSequence());
				relationEntity.setAttrCode(entity.getAttrCode());
				relationEntity.setAttrId(entity.getAttrId());
				relationEntity.setAttrName(entity.getAttrName());
				detailTenantRelationService.saveOrUpdate(relationEntity, false);
			}
		}else{
			//平台数据修改
			this.saveOrUpdate(entity, false);
		}
	}

	@Override
	public void initDefdoc() {
		//获取数据库表
		List<String> tableNameList = defdocDetailMapper.queryDefdocTableName();
		if(tableNameList!=null && tableNameList.size()>0){
//			for(String tableName : tableNameList){
//				String table = tableName;
//				table = table.replaceAll("ejc_support_", "");
//				String tenantId = table.replaceAll("_defdoc_detail", "");
//				defdocDetailMapper.updateTenantId(tableName, tenantId);
//			}
			List<DefdocDetailEntity> addEntities = new ArrayList<>();
			List<DefdocDetailTenantRelationEntity> addRelationEntities = new ArrayList<>();
			for(String tableName : tableNameList){
				List<DefdocDetailVO> defdocList = defdocDetailMapper.queryDataList(tableName);
				if(defdocList!=null && defdocList.size()>0){
					for(DefdocDetailVO vo : defdocList) {
						if ("新增".equals(vo.getType())) {
							addEntities.add(BeanMapper.map(vo, DefdocDetailEntity.class));
						}else if ("修改".equals(vo.getType())) {
							DefdocDetailTenantRelationEntity entity = BeanMapper.map(vo, DefdocDetailTenantRelationEntity.class);
							entity.setDetailId(entity.getId());
							entity.setId(IdWorker.getId());
							entity.setDel(0);
							addRelationEntities.add(entity);
						}else if ("删除".equals(vo.getType())) {
							DefdocDetailTenantRelationEntity entity = BeanMapper.map(vo, DefdocDetailTenantRelationEntity.class);
							entity.setDetailId(entity.getId());
							entity.setId(IdWorker.getId());
							entity.setDr(0);
							entity.setDel(1);
//							defdocDetailMapper.saveDetail(entity);
							addRelationEntities.add(entity);
						}
					}
				}
			}
			if(addEntities!=null && addEntities.size()>0){
				this.saveOrUpdateBatch(addEntities, addEntities.size(), false);
			}
			if(addRelationEntities!=null && addRelationEntities.size()>0){
				detailTenantRelationService.saveOrUpdateBatch(addRelationEntities, addRelationEntities.size(), false);
			}
		}
	}

}
