/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.bean.ReferEntity;
import com.ejianc.foundation.support.bean.ReferShowfieldEntity;
import com.ejianc.foundation.support.mapper.ReferMapper;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.service.IReferShowfieldService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReferServiceImpl
extends BaseServiceImpl<ReferMapper, ReferEntity>
implements IReferService {
    @Autowired
    private IReferShowfieldService referShowfieldService;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Value(value="${refer.base-host:null}")
    private String baseHost;

    @Override
    @Transactional
    public CommonResponse<String> saveOrUpdate(ReferVO referVo, boolean syncEs) {
        List codeEntity;
        ReferEntity entity = new ReferEntity();
        entity.setDr(0);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ref_code", (Object)referVo.getRefCode());
        queryWrapper.eq((Object)"dr", (Object)0);
        if (referVo.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)referVo.getId());
            codeEntity = this.list((Wrapper)queryWrapper);
            if (codeEntity != null && codeEntity.size() > 0) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u7167\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!!!");
            }
            ReferEntity oldEntity = (ReferEntity)((Object)super.getById((Serializable)referVo.getId()));
            oldEntity.setCodeField(referVo.getCodeField());
            oldEntity.setDataurl(referVo.getDataurl());
            oldEntity.setTreerelyurl(referVo.getTreerelyurl());
            oldEntity.setIdField(referVo.getIdField());
            oldEntity.setNameField(referVo.getNameField());
            oldEntity.setRefName(referVo.getRefName());
            oldEntity.setPageSize(referVo.getPageSize());
            oldEntity.setRefCode(referVo.getRefCode());
            oldEntity.setReferModule(referVo.getReferModule());
            oldEntity.setRefType(referVo.getRefType());
            oldEntity.setRemarks(referVo.getRemarks());
            oldEntity.setQueryMethod(referVo.getQueryMethod());
            oldEntity.setEnableBaseUrl(referVo.getEnableBaseUrl());
            oldEntity.setMultiRefCode(referVo.getMultiRefCode());
            oldEntity.setMultiRefName(referVo.getMultiRefName());
            oldEntity.setRelyfield(referVo.getRelyfield());
            entity = (ReferEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), ReferEntity.class));
        } else {
            codeEntity = this.list((Wrapper)queryWrapper);
            if (codeEntity != null && codeEntity.size() > 0) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u7167\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!!!");
            }
            referVo.setDr(Integer.valueOf(0));
            entity = (ReferEntity)((Object)BeanMapper.map((Object)referVo, ReferEntity.class));
        }
        this.saveOrUpdate((Object)entity, syncEs);
        List attributos = referVo.getGridheaders();
        ArrayList<ReferShowfieldEntity> attributoEntitys = new ArrayList<ReferShowfieldEntity>();
        ArrayList<Long> delattributosIds = new ArrayList<Long>();
        for (ReferShowfieldVO vo : attributos) {
            ReferShowfieldEntity en;
            if (StringUtils.isNotBlank((String)vo.getRowState()) && vo.getRowState().equals("add")) {
                en = (ReferShowfieldEntity)((Object)BeanMapper.map((Object)vo, ReferShowfieldEntity.class));
                en.setReferId(entity.getId());
                en.setDr(0);
                attributoEntitys.add(en);
            }
            if (StringUtils.isNotBlank((String)vo.getRowState()) && vo.getRowState().equals("edit")) {
                en = (ReferShowfieldEntity)((Object)BeanMapper.map((Object)vo, ReferShowfieldEntity.class));
                attributoEntitys.add(en);
            }
            if (!StringUtils.isNotBlank((String)vo.getRowState()) || !vo.getRowState().equals("del")) continue;
            delattributosIds.add(vo.getId());
        }
        if (attributoEntitys.size() > 0) {
            this.referShowfieldService.saveOrUpdateBatch(attributoEntitys, attributoEntitys.size(), syncEs);
        }
        if (delattributosIds.size() > 0) {
            this.referShowfieldService.removeByIds(delattributosIds, syncEs);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public ReferVO queryDetail(Long id) {
        ReferEntity entity = (ReferEntity)((Object)super.getById((Serializable)id));
        if (entity != null) {
            ModuleEntity moduleEntity;
            ReferVO vo = (ReferVO)BeanMapper.map((Object)((Object)entity), ReferVO.class);
            if (vo != null && vo.getReferModule() != null && (moduleEntity = this.moduleService.queryDetail(vo.getReferModule())) != null) {
                vo.setReferModuleName(moduleEntity.getModuleName());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"refer_id", (Object)id);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.orderByAsc((Object)"show_order");
            List<ReferShowfieldEntity> fileds = this.referShowfieldService.querylist((QueryWrapper<ReferShowfieldEntity>)queryWrapper);
            List vos = BeanMapper.mapList(fileds, ReferShowfieldVO.class);
            vo.setGridheaders(vos);
            return vo;
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u4e3b\u952e\u5bf9\u5e94\u7684\u8be6\u60c5");
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<Long> ids) {
        for (Long id : ids) {
            QueryParam queryParam = new QueryParam();
            HashMap<String, Parameter> paramMap = new HashMap<String, Parameter>();
            Parameter p = new Parameter("eq", (Object)id);
            paramMap.put("referId", p);
            queryParam.setParams(paramMap);
            List attribute = this.referShowfieldService.queryList(queryParam, false);
            if (attribute == null || attribute.size() <= 0) continue;
            ArrayList<Long> aIds = new ArrayList<Long>();
            for (ReferShowfieldEntity entity : attribute) {
                aIds.add(entity.getId());
            }
            this.referShowfieldService.delete(aIds);
        }
        super.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public ReferVO findByCode(String refCode) {
        ReferVO vo = new ReferVO();
        QueryParam queryParam = new QueryParam();
        HashMap<String, Parameter> paramMap = new HashMap<String, Parameter>();
        Parameter p = new Parameter("eq", (Object)refCode);
        paramMap.put("refCode", p);
        queryParam.setParams(paramMap);
        List pageData = this.queryList(queryParam, false);
        if (pageData != null && pageData.size() > 0) {
            ReferEntity en = (ReferEntity)((Object)pageData.get(0));
            vo = (ReferVO)BeanMapper.map((Object)((Object)en), ReferVO.class);
            if (vo.getEnableBaseUrl()) {
                if (StringUtils.isNotBlank((String)vo.getTreerelyurl()) && !vo.getTreerelyurl().contains("http")) {
                    if (StringUtils.isNotBlank((String)this.baseHost) && !"null".equals(this.baseHost)) {
                        vo.setTreerelyurl(this.baseHost + vo.getTreerelyurl());
                    } else {
                        vo.setTreerelyurl(this.environmentTools.getBaseHost() + vo.getTreerelyurl());
                    }
                }
                if (StringUtils.isNotBlank((String)vo.getDataurl()) && !vo.getDataurl().contains("http")) {
                    if (StringUtils.isNotBlank((String)this.baseHost) && !"null".equals(this.baseHost)) {
                        vo.setDataurl(this.baseHost + vo.getDataurl());
                    } else {
                        vo.setDataurl(this.environmentTools.getBaseHost() + vo.getDataurl());
                    }
                }
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"refer_id", (Object)en.getId());
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.orderByAsc((Object)"show_order");
            List<ReferShowfieldEntity> fileds = this.referShowfieldService.querylist((QueryWrapper<ReferShowfieldEntity>)queryWrapper);
            for (ReferShowfieldEntity filed : fileds) {
                if (!filed.getInnerFilter()) continue;
                vo.setInnerFilter(true);
                if (StringUtils.isNotBlank((String)vo.getInnerFilterColumns())) {
                    String cloumn = vo.getInnerFilterColumns() + "," + filed.getCode();
                    vo.setInnerFilterColumns(cloumn);
                    continue;
                }
                vo.setInnerFilterColumns(filed.getCode());
            }
            List vos = BeanMapper.mapList(fileds, ReferShowfieldVO.class);
            vo.setGridheaders(vos);
        }
        return vo;
    }

    @Override
    public IPage<ReferVO> pageList(QueryParam queryParam, boolean b) {
        Page backData = new Page();
        if (queryParam.getParams().get("referModule") != null) {
            String moduleId = ((Parameter)queryParam.getParams().get("referModule")).getValue().toString();
            List<ModuleVO> moduleVOs = this.moduleService.queryAllChildrenByPid(Long.parseLong(moduleId));
            ArrayList<Long> moduleIds = new ArrayList<Long>();
            for (ModuleVO vo : moduleVOs) {
                moduleIds.add(vo.getId());
            }
            ((Parameter)queryParam.getParams().get("referModule")).setType("in");
            ((Parameter)queryParam.getParams().get("referModule")).setValue(moduleIds);
        }
        IPage pageData = this.queryPage(queryParam, false);
        List entitys = pageData.getRecords();
        ArrayList<ReferVO> vos = new ArrayList<ReferVO>();
        ReferVO vo = null;
        for (ReferEntity entity : entitys) {
            ModuleEntity moduleEntity;
            vo = (ReferVO)BeanMapper.map((Object)((Object)entity), ReferVO.class);
            if (entity.getReferModule() != null && (moduleEntity = this.moduleService.queryDetail(entity.getReferModule())) != null) {
                vo.setReferModuleName(moduleEntity.getModuleName());
            }
            vos.add(vo);
        }
        backData.setCurrent(pageData.getCurrent());
        backData.setPages(pageData.getPages());
        backData.setRecords(vos);
        backData.setSize(pageData.getSize());
        backData.setTotal(pageData.getTotal());
        return backData;
    }
}

