package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author CJ
 * @Description:
 * @date 2021/2/2 14:56
 */
@RestController
@RequestMapping(value = "/api/refer/")
public class ReferApi {

    @Autowired
    private IReferService referService;

    @GetMapping(value = "findByCode")
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO vo = referService.findByCode(refCode);
        return CommonResponse.success(vo);
    }

}
