/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/materialApi/"})
public class MaterialApi {
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @PostMapping(value={"queryExitFlag"})
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
        MaterialVO vo = this.materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"queryExcelFlag"})
    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = this.materialService.queryExcelFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryName());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @PostMapping(value={"queryMaterialFlag"})
    public CommonResponse<List<MaterialVO>> queryMaterialFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = this.materialService.queryMaterialFlag(materialVO.getName(), materialVO.getSpec());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @PostMapping(value={"queryMaterialFlagByCode"})
    public CommonResponse<List<MaterialVO>> queryMaterialFlagByCode(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = this.materialService.queryMaterialFlagByCode(materialVO.getCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryByCode"})
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value="code") String code) {
        List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if (ListUtil.isNotEmpty(list)) {
            vo = (MaterialCategoryVO)BeanMapper.map((Object)list.get(0), MaterialCategoryVO.class);
        }
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u6240\u5c5e\u5206\u7c7b\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryCategoryListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryListByPid(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryListByChildren"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @PostMapping(value={"queryCategoryListByPost"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPost(@RequestBody List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialBySourceId"})
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = this.materialService.queryBySourceId(sourceId);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)entity, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialByIds(ids);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryCategoryById"})
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.materialCategoryService.queryDetail(id));
    }
}

