/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.bean.DefdocDetailTenantRelationEntity;
import com.ejianc.foundation.support.mapper.DefdocDetailMapper;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocDetailTenantRelationService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefdocDetailServiceImpl
extends BaseServiceImpl<DefdocDetailMapper, DefdocDetailEntity>
implements IDefdocDetailService {
    @Autowired
    private DefdocDetailMapper defdocDetailMapper;
    @Autowired
    private IDefdocDetailTenantRelationService detailTenantRelationService;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;

    private boolean isOmsTenant() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.OMS_TENANT.equals(tenantId.toString());
    }

    @Override
    public List<DefdocDetailVO> queryListByDefdocId(List<Long> ids) {
        StringBuffer buffer = new StringBuffer();
        if (ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                buffer.append(ids.get(i));
                if (i >= ids.size() - 1) continue;
                buffer.append(",");
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<DefdocDetailEntity> entity = this.defdocDetailMapper.queryListByDefdocId(buffer.toString(), tenantId);
        if (entity != null) {
            return BeanMapper.mapList(entity, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public List<DefdocDetailVO> getDefDocByDefId(Long defId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<DefdocDetailEntity> list = this.defdocDetailMapper.getDefDocByDefId(defId, tenantId);
        if (list != null) {
            return BeanMapper.mapList(list, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public List<DefdocDetailVO> getDefDocByDefId(Long defId, Long tenantId) {
        List<DefdocDetailEntity> list = this.defdocDetailMapper.getDefDocByDefId(defId, tenantId);
        if (list != null) {
            return BeanMapper.mapList(list, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public DefdocDetailVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        DefdocDetailEntity entity = this.defdocDetailMapper.queryDetail(id, tenantId);
        if (entity != null) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entity), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        DefdocDetailVO vo = this.queryDetail(id);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (!tenantId.toString().equals(this.OMS_TENANT) && vo.getTenantId().toString().equals(this.OMS_TENANT)) {
            DefdocDetailTenantRelationEntity relationEntity = (DefdocDetailTenantRelationEntity)((Object)BeanMapper.map((Object)vo, DefdocDetailTenantRelationEntity.class));
            relationEntity.setDetailId(relationEntity.getId());
            relationEntity.setId(null);
            relationEntity.setTenantId(null);
            relationEntity.setCreateTime(null);
            relationEntity.setCreateUserCode(null);
            relationEntity.setUpdateTime(null);
            relationEntity.setUpdateUserCode(null);
            relationEntity.setDr(0);
            relationEntity.setDel(1);
            this.detailTenantRelationService.saveOrUpdate((Object)relationEntity, false);
        } else if (!tenantId.toString().equals(this.OMS_TENANT) && tenantId.equals(vo.getTenantId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"id", (Object)vo.getId());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                this.removeById(vo.getId(), false);
            } else {
                DefdocDetailTenantRelationEntity relationEntity = (DefdocDetailTenantRelationEntity)((Object)BeanMapper.map((Object)vo, DefdocDetailTenantRelationEntity.class));
                relationEntity.setDetailId(relationEntity.getId());
                relationEntity.setTenantId(tenantId);
                relationEntity.setUpdateTime(new Date());
                relationEntity.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                this.defdocDetailMapper.delteDetail(relationEntity);
            }
        } else {
            this.removeById(vo.getId(), false);
        }
    }

    @Override
    public List<DefdocDetailVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<DefdocDetailEntity> entityList = this.defdocDetailMapper.queryListByPid(id, tenantId);
        if (entityList != null) {
            return BeanMapper.mapList(entityList, DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public void updateEnabled(DefdocDetailVO defdocDetailVo) {
        DefdocDetailVO vo = this.queryDetail(defdocDetailVo.getId());
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (!tenantId.toString().equals(this.OMS_TENANT) && vo.getTenantId().toString().equals(this.OMS_TENANT)) {
            DefdocDetailTenantRelationEntity relationEntity = (DefdocDetailTenantRelationEntity)((Object)BeanMapper.map((Object)vo, DefdocDetailTenantRelationEntity.class));
            relationEntity.setDetailId(relationEntity.getId());
            relationEntity.setId(null);
            relationEntity.setTenantId(null);
            relationEntity.setCreateTime(null);
            relationEntity.setCreateUserCode(null);
            relationEntity.setUpdateTime(null);
            relationEntity.setUpdateUserCode(null);
            relationEntity.setDel(0);
            relationEntity.setEnabled(defdocDetailVo.getEnabled());
            this.detailTenantRelationService.saveOrUpdate((Object)relationEntity, false);
        } else if (!tenantId.toString().equals(this.OMS_TENANT) && tenantId.equals(vo.getTenantId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"id", (Object)vo.getId());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                DefdocDetailEntity entity = (DefdocDetailEntity)((Object)this.selectById(defdocDetailVo.getId()));
                entity.setEnabled(defdocDetailVo.getEnabled());
                this.saveOrUpdate((Object)entity, false);
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
                queryWrapper.eq((Object)"detail_id", (Object)defdocDetailVo.getId());
                DefdocDetailTenantRelationEntity relationEntity = (DefdocDetailTenantRelationEntity)((Object)this.detailTenantRelationService.getOne((Wrapper)queryWrapper));
                relationEntity.setEnabled(defdocDetailVo.getEnabled());
                this.detailTenantRelationService.saveOrUpdate((Object)relationEntity, false);
            }
        } else {
            DefdocDetailEntity entity = (DefdocDetailEntity)((Object)this.selectById(defdocDetailVo.getId()));
            entity.setEnabled(defdocDetailVo.getEnabled());
            this.saveOrUpdate((Object)entity, false);
        }
    }

    @Override
    public DefdocDetailVO queryDetailByName(String name) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        condition.put("name", name);
        List<DefdocDetailEntity> entities = this.defdocDetailMapper.queryList(condition);
        if (entities != null && entities.size() > 0) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entities.get(0)), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public DefdocDetailVO getDefDocByName(Long defDocId, String name) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        condition.put("defDocId", defDocId);
        condition.put("name", name);
        List<DefdocDetailEntity> entities = this.defdocDetailMapper.getDefDocByName(condition);
        if (entities != null && entities.size() > 0) {
            return (DefdocDetailVO)BeanMapper.map((Object)((Object)entities.get(0)), DefdocDetailVO.class);
        }
        return null;
    }

    @Override
    public List<DefdocDetailEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<DefdocDetailEntity> resultList = this.defdocDetailMapper.queryList(condition);
        return resultList;
    }

    @Override
    public void saveDetail(DefdocDetailEntity entity) {
        this.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void updateDetail(DefdocDetailEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (!tenantId.toString().equals(this.OMS_TENANT) && entity.getTenantId().toString().equals(this.OMS_TENANT)) {
            DefdocDetailTenantRelationEntity relationEntity = (DefdocDetailTenantRelationEntity)((Object)BeanMapper.map((Object)((Object)entity), DefdocDetailTenantRelationEntity.class));
            relationEntity.setDetailId(relationEntity.getId());
            relationEntity.setId(null);
            relationEntity.setTenantId(null);
            relationEntity.setCreateTime(null);
            relationEntity.setCreateUserCode(null);
            relationEntity.setUpdateTime(null);
            relationEntity.setDel(0);
            relationEntity.setUpdateUserCode(null);
            this.detailTenantRelationService.saveOrUpdate((Object)relationEntity, false);
        } else if (!tenantId.toString().equals(this.OMS_TENANT) && tenantId.equals(entity.getTenantId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"id", (Object)entity.getId());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                this.saveOrUpdate((Object)entity, false);
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
                queryWrapper.eq((Object)"detail_id", (Object)entity.getId());
                DefdocDetailTenantRelationEntity relationEntity = (DefdocDetailTenantRelationEntity)((Object)this.detailTenantRelationService.getOne((Wrapper)queryWrapper));
                relationEntity.setEnabled(entity.getEnabled());
                relationEntity.setName(entity.getName());
                relationEntity.setCode(entity.getCode());
                relationEntity.setDescription(entity.getDescription());
                relationEntity.setSequence(entity.getSequence());
                relationEntity.setAttrCode(entity.getAttrCode());
                relationEntity.setAttrId(entity.getAttrId());
                relationEntity.setAttrName(entity.getAttrName());
                this.detailTenantRelationService.saveOrUpdate((Object)relationEntity, false);
            }
        } else {
            this.saveOrUpdate((Object)entity, false);
        }
    }

    @Override
    public void initDefdoc() {
        List<String> tableNameList = this.defdocDetailMapper.queryDefdocTableName();
        if (tableNameList != null && tableNameList.size() > 0) {
            ArrayList<Object> addEntities = new ArrayList<Object>();
            ArrayList<DefdocDetailTenantRelationEntity> addRelationEntities = new ArrayList<DefdocDetailTenantRelationEntity>();
            for (String tableName : tableNameList) {
                List<DefdocDetailVO> defdocList = this.defdocDetailMapper.queryDataList(tableName);
                if (defdocList == null || defdocList.size() <= 0) continue;
                for (DefdocDetailVO vo : defdocList) {
                    DefdocDetailTenantRelationEntity entity;
                    if ("\u65b0\u589e".equals(vo.getType())) {
                        addEntities.add(BeanMapper.map((Object)vo, DefdocDetailEntity.class));
                        continue;
                    }
                    if ("\u4fee\u6539".equals(vo.getType())) {
                        entity = (DefdocDetailTenantRelationEntity)((Object)BeanMapper.map((Object)vo, DefdocDetailTenantRelationEntity.class));
                        entity.setDetailId(entity.getId());
                        entity.setId(IdWorker.getId());
                        entity.setDel(0);
                        addRelationEntities.add(entity);
                        continue;
                    }
                    if (!"\u5220\u9664".equals(vo.getType())) continue;
                    entity = (DefdocDetailTenantRelationEntity)((Object)BeanMapper.map((Object)vo, DefdocDetailTenantRelationEntity.class));
                    entity.setDetailId(entity.getId());
                    entity.setId(IdWorker.getId());
                    entity.setDr(0);
                    entity.setDel(1);
                    addRelationEntities.add(entity);
                }
            }
            if (addEntities != null && addEntities.size() > 0) {
                this.saveOrUpdateBatch(addEntities, addEntities.size(), false);
            }
            if (addRelationEntities != null && addRelationEntities.size() > 0) {
                this.detailTenantRelationService.saveOrUpdateBatch(addRelationEntities, addRelationEntities.size(), false);
            }
        }
    }
}

