package com.ejianc.foundation.support.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/def_doc/")
public class DefdocApi {
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private IDefdocService defdocService;

	@RequestMapping(value = "getDefDocById", method=RequestMethod.GET)
	public CommonResponse<DefdocDetailVO> getDefDocById(@RequestParam(value="id") Long id) {
		DefdocDetailVO defdocDetailVo = defdocDetailService.queryDetail(id);
		return CommonResponse.success(defdocDetailVo);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/1/15 根据档案id（注意：不是档案项id） 查询该档案所有档案项
	 * @Description getDefDocByName
	 * @Param defId 档案id（注意：不是档案项id）
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "getDefDocByDefId", method=RequestMethod.GET)
	public CommonResponse<List<DefdocDetailVO>> getDefDocByDefId(@RequestParam(value="defId") Long defId) {
		List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(defId);
		return CommonResponse.success(list);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021-9-14 根据档案编码  查询该档案所有档案项
	 * @Description getDefDocDetailByDefCode
	 * @Param defCode 档案编码
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "getDefDocByDefCode", method=RequestMethod.GET)
	public CommonResponse<List<DefdocDetailVO>> getDefDocByDefCode(@RequestParam(value="defCode") String defCode) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defCode);
		if(defdocVo == null){
			return CommonResponse.error("查询失败,没有该档案编码！");
		}
		List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(defdocVo.getId());
		return CommonResponse.success(list);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021-9-14 根据档案编码  查询该档案所有档案项
	 * @Description getDefDocDetailByDefCodeAndTenantId
	 * @Param defCode 档案编码
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "getDefDocDetailByDefCodeAndTenantId", method=RequestMethod.GET)
	public CommonResponse<List<DefdocDetailVO>> getDefDocDetailByDefCodeAndTenantId(@RequestParam(value="defCode") String defCode,@RequestParam(value="tenantId") Long tenantId) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defCode);
		if(defdocVo == null){
			return CommonResponse.error("查询失败,没有该档案编码！");
		}
		List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(defdocVo.getId(),tenantId);
		return CommonResponse.success(list);
	}

	@RequestMapping(value = "getDefDocByName", method=RequestMethod.GET)
	public CommonResponse<DefdocDetailVO> getDefDocByName(@RequestParam(value="defDocId") Long defDocId,@RequestParam(value="name") String name) {
		if(defDocId == null || StringUtils.isEmpty(name)){
			return CommonResponse.error("参数不能为空！");
		}
		DefdocDetailVO defdocDetailVo = defdocDetailService.getDefDocByName(defDocId,name);
		return CommonResponse.success(defdocDetailVo);
	}

	@GetMapping(value = "detailListByDetailNamesAndDocCode")
	public CommonResponse<List<DefdocDetailVO>>  detailListByDetailNamesAndDocCode(@RequestParam String[] detailNames, @RequestParam String docCode) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(docCode);
		Long tenantId = InvocationInfoProxy.getTenantid();
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		queryParam.getParams().put("names", new Parameter(QueryParam.IN, detailNames));
		List<DefdocDetailEntity> detailList = defdocDetailService.queryList(queryParam);
		return CommonResponse.success(BeanMapper.mapList(detailList, DefdocDetailVO.class));
	}
	@GetMapping(value = "no_auth/detailListByDetailNamesAndDocCode")
	public CommonResponse<List<DefdocDetailVO>>  noAuthDetailListByDetailNamesAndDocCode(@RequestParam List<String> detailNames, @RequestParam String docCode) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(docCode);
//		Long tenantId = InvocationInfoProxy.getTenantid();
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, "999999"));
		queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		queryParam.getParams().put("names", new Parameter(QueryParam.IN, detailNames));
		List<DefdocDetailEntity> detailList = defdocDetailService.queryList(queryParam);
		return CommonResponse.success(BeanMapper.mapList(detailList, DefdocDetailVO.class));
	}

	@GetMapping("/detailListByDefdocCode")
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> queryDetailListByDefdocCode(@RequestParam String defdocTypeCode,
																				 @RequestParam(value = "condition", required = false) String condition) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defdocTypeCode);
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(org.apache.commons.lang.StringUtils.isNotBlank(condition) && !"null".equals(condition)) {
			JSONObject jsonParam = JSONObject.parseObject(condition);
			if(null != jsonParam.get("tenantId")) {
				tenantId = Long.valueOf(jsonParam.get("tenantId").toString());
			}
		}
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
	}

	@GetMapping("/detailListByDefdocCodeList")
	@ResponseBody
	public CommonResponse<List<DefdocDetailVO>> detailListByDefdocCodeList(@RequestParam List<String> defdocTypeCodeList) {
		List<DefdocVO> defdocVoList = defdocService.queryUniqueByCodeList(defdocTypeCodeList);
		Long tenantId = InvocationInfoProxy.getTenantid();
		QueryParam queryParam = new QueryParam();
		Map<Long, String> defdocMap = new HashMap<>();
		if (CollectionUtils.isNotEmpty(defdocVoList)){
			defdocMap = defdocVoList.stream().collect(Collectors.toMap(DefdocVO::getId, DefdocVO::getCode, (key1, key2) -> key2));
		}
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getParams().put("docIds", new Parameter(QueryParam.IN, defdocMap.keySet()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
		List<DefdocDetailVO> resultMapList = BeanMapper.mapList(dataList, DefdocDetailVO.class);
		for (DefdocDetailVO defdocDetailVO : resultMapList) {
			if (defdocMap.containsKey(defdocDetailVO.getDefdocId())){
				defdocDetailVO.setParentCode(defdocMap.get(defdocDetailVO.getDefdocId()));
				defdocDetailVO.setParentId(defdocDetailVO.getDefdocId());
			}
		}
		return CommonResponse.success(resultMapList);
	}

	
	/**
	 * 根据档案编码查询档案信息
	 * 
	 * @param defdocCode
	 * @return
	 */
	@RequestMapping(value = "getDefdocByDefCode", method=RequestMethod.GET)
	public CommonResponse<DefdocVO> getDefdocByDefCode(@RequestParam(value="defdocCode") String defdocCode) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defdocCode);
		return CommonResponse.success(defdocVo);
	}
}
