/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.BillParamCustomVO;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billParam"})
public class BillParamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillParamService service;
    @Value(value="${oms.tenantid}")
    private Long omsTenantId;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillParamCustomService billParamCustomService;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillParamVO> saveOrUpdate(@RequestBody BillParamVO billParamVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (billParamVO.getId() == null && billParamVO.getCode() == null) {
            if (this.omsTenantId.equals(tenantId)) {
                String billCode = "";
                try {
                    CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode("param-register-001", InvocationInfoProxy.getTenantid());
                    if (!codeResp.isSuccess()) {
                        throw new BusinessException("\u751f\u6210\u5355\u636e\u7f16\u7801\u5931\u8d25\uff1a" + codeResp.getMsg());
                    }
                    billCode = (String)codeResp.getData();
                }
                catch (Exception e) {
                    return CommonResponse.error((String)e.getMessage());
                }
                billParamVO.setCode(billCode);
            } else {
                return CommonResponse.error((String)"\u65e0\u6743\u65b0\u589e\uff01");
            }
        }
        if (billParamVO.getOrgId() != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("orgId", new Parameter("eq", (Object)billParamVO.getOrgId()));
            param.getParams().put("code", new Parameter("eq", (Object)billParamVO.getCode()));
            param.getParams().put("id", new Parameter("ne", (Object)billParamVO.getId()));
            List billParamEntities = this.service.queryList(param);
            if (ListUtil.isNotEmpty((List)billParamEntities)) {
                return CommonResponse.error((String)"\u8be5\u7ec4\u7ec7\u5df2\u914d\u7f6e\uff01");
            }
        }
        BillParamEntity entity = (BillParamEntity)((Object)BeanMapper.map((Object)billParamVO, BillParamEntity.class));
        if (billParamVO.getId() != null) {
            BillParamEntity db = (BillParamEntity)((Object)this.service.getById(entity.getId()));
            if (db.getTenantId().equals(999999L) && StringUtils.isEmpty((CharSequence)db.getOrgName())) {
                if (billParamVO.getCustomVOS().isEmpty()) {
                    entity.setTenantId(tenantId);
                    this.service.saveOrUpdate((Object)entity, false);
                }
            } else {
                entity.setTenantId(tenantId);
                this.service.saveOrUpdate((Object)entity, false);
            }
        } else {
            entity.setTenantId(tenantId);
            this.service.saveOrUpdate((Object)entity, false);
        }
        BillParamVO vo = (BillParamVO)BeanMapper.map((Object)((Object)entity), BillParamVO.class);
        if (!billParamVO.getCustomVOS().isEmpty()) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            param.getParams().put("pid", new Parameter("eq", (Object)billParamVO.getId()));
            List customEntities = this.billParamCustomService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)customEntities)) {
                this.billParamCustomService.removeByIds(customEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
            customEntities = BeanMapper.mapList((Iterable)billParamVO.getCustomVOS(), BillParamCustomEntity.class);
            for (BillParamCustomEntity customEntity : customEntities) {
                customEntity.setTenantId(tenantId);
                customEntity.setPid(entity.getId());
            }
            this.billParamCustomService.saveOrUpdateBatch(customEntities);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillParamVO> queryDetail(Long id) {
        DefdocDetailVO defdocDetailVo;
        BillParamEntity entity = (BillParamEntity)((Object)this.service.selectById(id));
        BillParamVO vo = (BillParamVO)BeanMapper.map((Object)((Object)entity), BillParamVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("pid", new Parameter("eq", (Object)id));
        List customEntities = this.billParamCustomService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)customEntities)) {
            vo.setCustomVOS(BeanMapper.mapList((Iterable)customEntities, BillParamCustomVO.class));
        }
        if ((defdocDetailVo = this.defdocDetailService.queryDetail(Long.parseLong(entity.getModuleId()))) == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u53c2\u6570\u5206\u7c7b\uff01");
        }
        vo.setModuleName(defdocDetailVo.getName());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillParamVO> vos) {
        if (vos.size() > 1) {
            return CommonResponse.error((String)"\u53ea\u80fd\u5355\u4e2a\u5220\u9664\uff01");
        }
        BillParamEntity billParamEntity = (BillParamEntity)((Object)this.service.selectById(vos.get(0).getId()));
        if (!billParamEntity.getTenantId().equals(InvocationInfoProxy.getTenantid())) {
            return CommonResponse.error((String)"\u65e0\u6743\u5220\u9664\uff01");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List customEntities = this.billParamCustomService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)customEntities)) {
            this.billParamCustomService.removeByIds(customEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillParamVO>> queryList(@RequestBody QueryParam param) {
        if (!InvocationInfoProxy.getTenantid().equals(this.omsTenantId)) {
            return CommonResponse.error((String)"\u65e0\u6743\u67e5\u8be2\uff01");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)this.omsTenantId));
        param.getParams().put("orgId", new Parameter("eq", null));
        param.getOrderMap().put("code", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), BillParamVO.class);
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListCus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillParamVO>> queryListCus(@RequestBody QueryParam param) {
        param.getOrderMap().put("code", "asc");
        if (param.getParams().get("groupOnly") != null) {
            param.getParams().remove("groupOnly");
            CommonResponse<OrgVO> root = this.getRootOrg();
            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic("and");
            complexParam.getParams().put("orgId", new Parameter("eq", (Object)((OrgVO)root.getData()).getId()));
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("or");
            c1.getParams().put("orgId", new Parameter("eq", null));
            c1.getParams().put("tenantId", new Parameter("eq", (Object)this.omsTenantId));
            complexParam.getComplexParams().add(c1);
            param.getComplexParams().add(complexParam);
        } else {
            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic("and");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("or");
            c1.getParams().put("orgId", new Parameter("eq", null));
            c1.getParams().put("tenantId", new Parameter("eq", (Object)this.omsTenantId));
            ArrayList orgIds = new ArrayList();
            CommonResponse response = this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
            if (!response.isSuccess() || ListUtil.isEmpty((List)((List)response.getData()))) {
                return CommonResponse.error((String)"\u67e5\u8be2\u672c\u4e0a\u7ec4\u7ec7\u51fa\u9519");
            }
            orgIds.addAll(((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            response = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            if (!response.isSuccess() || ListUtil.isEmpty((List)((List)response.getData()))) {
                return CommonResponse.error((String)"\u67e5\u8be2\u672c\u4e0b\u7ec4\u7ec7\u51fa\u9519");
            }
            orgIds.addAll(((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("orgId", new Parameter("in", orgIds));
            complexParam.getComplexParams().add(c1);
            complexParam.getComplexParams().add(c2);
            param.getComplexParams().add(complexParam);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), BillParamVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (BillParamVO vo : records) {
                QueryParam p = new QueryParam();
                p.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                p.getParams().put("pid", new Parameter("eq", (Object)vo.getId()));
                List customEntities = this.billParamCustomService.queryList(p, false);
                if (!ListUtil.isNotEmpty((List)customEntities)) continue;
                vo.setCustomVOS(BeanMapper.mapList((Iterable)customEntities, BillParamCustomVO.class));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getRootOrg"}, method={RequestMethod.GET})
    @ResponseBody
    private CommonResponse<OrgVO> getRootOrg() {
        return this.iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
    }

    @RequestMapping(value={"/publishParamConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> publishParamConfig(@RequestBody PublishVO publishVO) {
        return this.service.publishParamConfig(publishVO);
    }
}

