/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/def_doc/"})
public class DefdocApi {
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IDefdocService defdocService;

    @RequestMapping(value={"getDefDocById"}, method={RequestMethod.GET})
    public CommonResponse<DefdocDetailVO> getDefDocById(@RequestParam(value="id") Long id) {
        DefdocDetailVO defdocDetailVo = this.defdocDetailService.queryDetail(id);
        return CommonResponse.success((Object)defdocDetailVo);
    }

    @RequestMapping(value={"getDefDocByDefId"}, method={RequestMethod.GET})
    public CommonResponse<List<DefdocDetailVO>> getDefDocByDefId(@RequestParam(value="defId") Long defId) {
        List<DefdocDetailVO> list = this.defdocDetailService.getDefDocByDefId(defId);
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"getDefDocByDefCode"}, method={RequestMethod.GET})
    public CommonResponse<List<DefdocDetailVO>> getDefDocByDefCode(@RequestParam(value="defCode") String defCode) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defCode);
        if (defdocVo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u8be5\u6863\u6848\u7f16\u7801\uff01");
        }
        List<DefdocDetailVO> list = this.defdocDetailService.getDefDocByDefId(defdocVo.getId());
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"getDefDocDetailByDefCodeAndTenantId"}, method={RequestMethod.GET})
    public CommonResponse<List<DefdocDetailVO>> getDefDocDetailByDefCodeAndTenantId(@RequestParam(value="defCode") String defCode, @RequestParam(value="tenantId") Long tenantId) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defCode);
        if (defdocVo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u8be5\u6863\u6848\u7f16\u7801\uff01");
        }
        List<DefdocDetailVO> list = this.defdocDetailService.getDefDocByDefId(defdocVo.getId(), tenantId);
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"getDefDocByName"}, method={RequestMethod.GET})
    public CommonResponse<DefdocDetailVO> getDefDocByName(@RequestParam(value="defDocId") Long defDocId, @RequestParam(value="name") String name) {
        if (defDocId == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)name)) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DefdocDetailVO defdocDetailVo = this.defdocDetailService.getDefDocByName(defDocId, name);
        return CommonResponse.success((Object)defdocDetailVo);
    }

    @GetMapping(value={"detailListByDetailNamesAndDocCode"})
    public CommonResponse<List<DefdocDetailVO>> detailListByDetailNamesAndDocCode(@RequestParam String[] detailNames, @RequestParam String docCode) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(docCode);
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        queryParam.getParams().put("names", new Parameter("in", (Object)detailNames));
        List<DefdocDetailEntity> detailList = this.defdocDetailService.queryList(queryParam);
        return CommonResponse.success((Object)BeanMapper.mapList(detailList, DefdocDetailVO.class));
    }

    @GetMapping(value={"no_auth/detailListByDetailNamesAndDocCode"})
    public CommonResponse<List<DefdocDetailVO>> noAuthDetailListByDetailNamesAndDocCode(@RequestParam List<String> detailNames, @RequestParam String docCode) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(docCode);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)"999999"));
        queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        queryParam.getParams().put("names", new Parameter("in", detailNames));
        List<DefdocDetailEntity> detailList = this.defdocDetailService.queryList(queryParam);
        return CommonResponse.success((Object)BeanMapper.mapList(detailList, DefdocDetailVO.class));
    }

    @GetMapping(value={"/detailListByDefdocCode"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryDetailListByDefdocCode(@RequestParam String defdocTypeCode, @RequestParam(value="condition", required=false) String condition) {
        JSONObject jsonParam;
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defdocTypeCode);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isNotBlank((String)condition) && !"null".equals(condition) && null != (jsonParam = JSONObject.parseObject((String)condition)).get((Object)"tenantId")) {
            tenantId = Long.valueOf(jsonParam.get((Object)"tenantId").toString());
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
    }

    @GetMapping(value={"/detailListByDefdocCodeList"})
    @ResponseBody
    public CommonResponse<List<DefdocDetailVO>> detailListByDefdocCodeList(@RequestParam List<String> defdocTypeCodeList) {
        List<DefdocVO> defdocVoList = this.defdocService.queryUniqueByCodeList(defdocTypeCodeList);
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryParam queryParam = new QueryParam();
        Map<Object, Object> defdocMap = new HashMap();
        if (CollectionUtils.isNotEmpty(defdocVoList)) {
            defdocMap = defdocVoList.stream().collect(Collectors.toMap(BaseVO::getId, DefdocVO::getCode, (key1, key2) -> key2));
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("docIds", new Parameter("in", defdocMap.keySet()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, DefdocDetailVO.class);
        for (DefdocDetailVO defdocDetailVO : resultMapList) {
            if (!defdocMap.containsKey(defdocDetailVO.getDefdocId())) continue;
            defdocDetailVO.setParentCode((String)defdocMap.get(defdocDetailVO.getDefdocId()));
            defdocDetailVO.setParentId(defdocDetailVO.getDefdocId());
        }
        return CommonResponse.success((Object)resultMapList);
    }

    @RequestMapping(value={"getDefdocByDefCode"}, method={RequestMethod.GET})
    public CommonResponse<DefdocVO> getDefdocByDefCode(@RequestParam(value="defdocCode") String defdocCode) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defdocCode);
        return CommonResponse.success((Object)defdocVo);
    }
}

