/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/param/config/"})
public class ParamConfigApi {
    @Autowired
    private IParamRegisterSetService iParamRegisterSetService;
    @Autowired
    private IBillParamService billParamService;
    @Autowired
    private IBillParamCustomService billParamCustomService;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String paramWarnControl = "P-N5f1Bc0150";

    @RequestMapping(value={"getByCode"}, method={RequestMethod.GET})
    public CommonResponse<ParamRegisterSetVO> getByCode(@RequestParam(value="code") String code) {
        ParamRegisterSetEntity entity = this.iParamRegisterSetService.getByCode(code);
        if (entity == null) {
            return CommonResponse.error((String)"\u8be5\u53c2\u6570\u5c1a\u672a\u914d\u7f6e\uff01");
        }
        ParamRegisterSetVO vo = (ParamRegisterSetVO)BeanMapper.map((Object)((Object)entity), ParamRegisterSetVO.class);
        return CommonResponse.success((Object)vo);
    }

    @Deprecated
    @RequestMapping(value={"getBillParamByCode"}, method={RequestMethod.GET})
    public CommonResponse<BillParamVO> getBillParamByCode(@RequestParam(value="code") String code) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter("eq", (Object)code));
        List setEntities = this.billParamService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)setEntities)) {
            param = new QueryParam();
            BillParamEntity billParamEntity = (BillParamEntity)((Object)setEntities.get(0));
            param.getParams().put("pid", new Parameter("eq", (Object)billParamEntity.getId()));
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List sutEntities = this.billParamCustomService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)sutEntities)) {
                BillParamCustomEntity customEntity = (BillParamCustomEntity)((Object)sutEntities.get(0));
                billParamEntity.setControlType(customEntity.getControlType());
                billParamEntity.setRoleValue(customEntity.getRoleValue());
            }
        } else {
            return CommonResponse.error((String)"\u8be5\u53c2\u6570\u672a\u53d1\u5e03\u6216\u8005\u6ca1\u6709\u5b9a\u4e49\uff01");
        }
        BillParamVO vo = (BillParamVO)BeanMapper.map(setEntities.get(0), BillParamVO.class);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"getBillParamByCodeAndOrgId"}, method={RequestMethod.GET})
    public CommonResponse<List<BillParamVO>> getBillParamByCodeAndOrgId(@RequestParam(value="code") String code, @RequestParam(value="orgId") Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter("eq", (Object)code));
        List setEntities = null;
        ArrayList<Object> res = new ArrayList<Object>();
        ParamRegisterSetEntity entity = this.iParamRegisterSetService.getByCode(paramWarnControl);
        if (entity == null || "1".equals(entity.getValueData())) {
            CommonResponse response = this.iOrgApi.getOneById(orgId);
            if (!response.isSuccess() || response.getData() == null) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9884\u8b66\u8bbe\u7f6e\u7ec4\u7ec7");
            }
            OrgVO orgVO = (OrgVO)response.getData();
            String innerCode = orgVO.getInnerCode();
            String[] parentIds = innerCode.split("\\|");
            for (int i = parentIds.length - 1; i >= 0; --i) {
                Long pOrgId = Long.parseLong(parentIds[i]);
                param.getParams().put("orgId", new Parameter("eq", (Object)pOrgId));
                setEntities = this.billParamService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)setEntities)) break;
            }
            if (ListUtil.isEmpty(setEntities)) {
                param.getParams().put("tenantId", new Parameter("eq", (Object)"999999"));
                param.getParams().put("orgId", new Parameter("eq", null));
                setEntities = this.billParamService.queryList(param, false);
            }
        } else {
            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic("and");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("or");
            c1.getParams().put("tenantId", new Parameter("eq", (Object)"999999"));
            c1.getParams().put("orgId", new Parameter("eq", null));
            CommonResponse response = this.iOrgApi.findParentsByOrgId(orgId);
            if (!response.isSuccess() || ListUtil.isEmpty((List)((List)response.getData()))) {
                return CommonResponse.error((String)"\u67e5\u8be2\u672c\u4e0a\u7ec4\u7ec7\u51fa\u9519");
            }
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("orgId", new Parameter("in", ((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            complexParam.getComplexParams().add(c1);
            complexParam.getComplexParams().add(c2);
            param.getComplexParams().add(complexParam);
            setEntities = this.billParamService.queryList(param, false);
        }
        if (ListUtil.isNotEmpty(setEntities)) {
            param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)code));
            param.getParams().put("tenantId", new Parameter("eq", (Object)"999999"));
            param.getParams().put("orgId", new Parameter("eq", null));
            List baseSet = this.billParamService.queryList(param, false);
            if (ListUtil.isEmpty((List)baseSet)) {
                return CommonResponse.error((String)"\u8be5\u53c2\u6570\u672a\u53d1\u5e03\u6216\u8005\u6ca1\u6709\u5b9a\u4e49\uff01");
            }
            param = new QueryParam();
            param.getParams().put("pid", new Parameter("eq", (Object)((BillParamEntity)((Object)baseSet.get(0))).getId()));
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List customEntities = this.billParamCustomService.queryList(param, false);
            BillParamEntity billParamEntity = null;
            if (ListUtil.isEmpty((List)customEntities)) {
                billParamEntity = (BillParamEntity)((Object)baseSet.get(0));
                OrgVO baseOrg = (OrgVO)this.iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid()).getData();
                billParamEntity.setOrgId(baseOrg.getId());
                billParamEntity.setOrgName(baseOrg.getName());
            }
            param = new QueryParam();
            param.getParams().put("pid", new Parameter("in", setEntities.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            customEntities = this.billParamCustomService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)customEntities)) {
                if (billParamEntity != null) {
                    res.add(BeanMapper.map((Object)((Object)billParamEntity), BillParamVO.class));
                }
                for (BillParamCustomEntity customEntity : customEntities) {
                    for (BillParamEntity paramEntity : setEntities) {
                        if (!paramEntity.getId().equals(customEntity.getPid())) continue;
                        billParamEntity = paramEntity;
                        break;
                    }
                    billParamEntity.setControlType(customEntity.getControlType());
                    billParamEntity.setRoleValue(customEntity.getRoleValue());
                    if (billParamEntity.getOrgId() == null) {
                        OrgVO baseOrg = (OrgVO)this.iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid()).getData();
                        billParamEntity.setOrgId(baseOrg.getId());
                        billParamEntity.setOrgName(baseOrg.getName());
                    }
                    res.add(BeanMapper.map((Object)((Object)billParamEntity), BillParamVO.class));
                }
            } else {
                res.add(BeanMapper.map((Object)((Object)billParamEntity), BillParamVO.class));
            }
        } else {
            return CommonResponse.error((String)"\u8be5\u53c2\u6570\u672a\u53d1\u5e03\u6216\u8005\u6ca1\u6709\u5b9a\u4e49\uff01");
        }
        res.sort(Comparator.comparing(BillParamVO::getRoleValue));
        return CommonResponse.success(res);
    }
}

