/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.service.IMaterialCategoryCr12gService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialCr12g/category/"})
public class MaterialCategoryCr12gController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IMaterialCategoryCr12gService materialCategoryCr12gService;

    @RequestMapping(value={"materialTreeRef"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> materialTreeRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<MaterialCategoryVO> dataList = null;
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            params.put("searchText", searchText);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        dataList = this.materialCategoryCr12gService.queryListTree(params);
        List map = BeanMapper.mapList(dataList, Map.class);
        return ResultAsTree.createTreeData((List)map);
    }

    @RequestMapping(value={"/lazyMaterialCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyMaterialCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<MaterialCategoryVO> dataList = null;
        Integer assetType = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)condition)) {
                Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
                Integer n = assetType = conditionMap.get("assetType") == null ? null : Integer.valueOf(conditionMap.get("assetType").toString());
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                if (null != assetType) {
                    params.put("assetType", assetType);
                }
                dataList = this.materialCategoryCr12gService.queryListTree(params);
            } else {
                dataList = this.materialCategoryCr12gService.queryListByPidAndAssetType(pid, assetType);
            }
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }
}

