package com.ejianc.foundation.share.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectEntity;
import com.ejianc.foundation.share.controller.api.CustomerApi;
import com.ejianc.foundation.share.service.IProjectService;
import com.ejianc.foundation.share.vo.ProjectPriceVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;

/**
 * 中建科技项目
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("project")
public class ProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
	@Autowired
	private IDefdocService defdocService;
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private CustomerApi customerApi;
    @Autowired
    private IProjectService service;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private EnvironmentTools environmentTools;

    /**
     * @Description temporarySave 暂存
     */
    @RequestMapping(value = "/temporarySave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVO> temporarySave(@RequestBody ProjectVO saveorUpdateVO) {
    	ProjectVO vo = service.temporarySave(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVO> saveOrUpdate(@RequestBody ProjectVO saveorUpdateVO) {
    	ProjectVO vo = service.saveData(saveorUpdateVO);
        //查询项目成员
    	vo.setMembersList((List<Map<String, Object>>) getRespData(userApi.getEmployeeList(vo.getProjectDepartmentId()), false, null));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectVO> queryDetail(Long id) {
    	ProjectEntity entity = service.selectById(id);
    	ProjectVO vo = BeanMapper.map(entity, ProjectVO.class);
    	List<ProjectPriceVO> projectPriceList = new ArrayList<>();
    	ProjectPriceVO ProjectPriceVO = BeanMapper.map(entity, ProjectPriceVO.class);
    	projectPriceList.add(ProjectPriceVO);
    	vo.setProjectPriceList(projectPriceList);

        //查询项目成员
        CommonResponse<List<Map<String, Object>>>  membersResp = userApi.getEmployeeList(vo.getProjectDepartmentId());
        if(!membersResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取项目成员失败。");
        }
        vo.setMembersList(membersResp.getData());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectVO> vos) {
    	return service.delProject(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("constructionUnitName");
        fuzzyFields.add("designUnit");
        fuzzyFields.add("contractualModelName");
        fuzzyFields.add("investmentSourceName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("structureType");
        fuzzyFields.add("priceMethod");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
        	param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
        	param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<ProjectEntity> page = service.queryPage(param,false);
        IPage<ProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
        	param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
        	param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<ProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("project-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> refProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("constructionUnitName");
        fuzzyFields.add("designUnit");
        fuzzyFields.add("contractualModelName");
        fuzzyFields.add("investmentSourceName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("structureType");
        fuzzyFields.add("priceMethod");
        //启用
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
		/** 移动端参照标识 */
		Boolean mobileLeave = false;
		if(StringUtils.isNotBlank(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(null != _con.get("mobileLeave")) {
				//移动端数据
				mobileLeave = true;
			}
		}
		if(mobileLeave){
			//移动端没有当前组织，按照当前登录人权限取组织
			CommonResponse<List<OrgVO>> response = iOrgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
			if(response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())){
				param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, response.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
			}
		} else {
			List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
			List<Long> commonOrgIds = new ArrayList<>();
			List<Long> departmentIds = new ArrayList<>();
			orgVOList.stream().forEach(org -> {
				if(5 == org.getOrgType()) {
					//项目部
					departmentIds.add(org.getId());
				} else {
					//普通组织
					commonOrgIds.add(org.getId());
				}
			});
			if(CollectionUtils.isNotEmpty(commonOrgIds)) {
				param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
			} else if(CollectionUtils.isNotEmpty(departmentIds)) {
				param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
			}
		}
        param.getOrderMap().put("createTime", QueryParam.DESC);

        logger.info("refProjectData查询条件condition：{}", condition);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("range")!=null && "all".equals(_con.get("range").toString())){
				param.getParams().remove("orgId");
				param.getParams().remove("projectDepartmentId");
			}
			if(StringUtils.isNotEmpty(_con.getString("projectType"))){
				if(Objects.equals("1", _con.getString("projectType"))){
					param.getParams().put("projectType", new Parameter(QueryParam.EQ, "施工类"));
					param.getParams().put("status", new Parameter(QueryParam.EQ, "2"));
				}
			}
        }

        IPage<ProjectEntity> page = service.queryPage(param,false);
        IPage<ProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<ProjectVO> projectVOS = BeanMapper.mapList(page.getRecords(), ProjectVO.class);
		for(ProjectVO projectVO : projectVOS){
			projectVO.setName(projectVO.getProjectName());
		}
		pageData.setRecords(projectVOS);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    //启停用
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ProjectVO projectRegisterVO) {
    	return service.changeState(projectRegisterVO);
    }

    /**
     * @Description saveintegratedCode 保存一体化编码
     */
    @RequestMapping(value = "/saveintegratedCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveintegratedCode(@RequestBody ProjectVO saveorUpdateVO) {
    	ProjectEntity entity = service.selectById(saveorUpdateVO.getId());
    	entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
    	service.saveOrUpdate(entity, false);
		return CommonResponse.success("保存一体化编码成功");
    }

	/**
	 * excel导入
	 *
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportProject", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportProject(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		Long tenantId = InvocationInfoProxy.getTenantid();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }

		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			//只读第一页（sheet）
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			if(result != null && result.size() > 0) {
				Map<String,Long> qualityAgreementMap = new HashMap<>();
				Map<String,Long> contractualModelMap = new HashMap<>();
				Map<String,Long> investmentSourceMap = new HashMap<>();
				Map<String,Long> typeMap = new HashMap<>();
				Map<String,Long> projectCategoryMap = new HashMap<>();
				Map<String,Long> signStatusMap = new HashMap<>();
				Map<String,Long> biddingFormMap = new HashMap<>();
				Map<Long,String> customerTypeMap = new HashMap<>();

				Map<String,Long> orgMap = new HashMap<>();

				DefdocVO qualityAgreementdefdocVo = defdocService.queryUniqueByCode("zjkj-qualityAgreement");//质量约定
				if(qualityAgreementdefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(qualityAgreementdefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							qualityAgreementMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO contractualModeldefdocVo = defdocService.queryUniqueByCode("zjkj-contractualModel");//承包模式
				if(contractualModeldefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(contractualModeldefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							contractualModelMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO investmentSourcedefdocVo = defdocService.queryUniqueByCode("zjkj-contractualModel");//投资来源
				if(investmentSourcedefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(investmentSourcedefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							investmentSourceMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO typedefdocVo = defdocService.queryUniqueByCode("zjkj-type");//建筑类型
				if(typedefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(typedefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							typeMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO projectCategorydefdocVo = defdocService.queryUniqueByCode("zjkj-projectCategory");//项目类别
				if(projectCategorydefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(projectCategorydefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							projectCategoryMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO signStatusdefdocVo = defdocService.queryUniqueByCode("zjkj-signStatus");//签约状态
				if(signStatusdefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(signStatusdefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							signStatusMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO biddingFormdefdocVo = defdocService.queryUniqueByCode("zjkj-biddingForm");//招标形式
				if(biddingFormdefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(biddingFormdefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							biddingFormMap.put(vo.getName(), vo.getId());
						}
					}
				}

				DefdocVO customerTypedefdocVo = defdocService.queryUniqueByCode("customer_type");//客户类型
				if(customerTypedefdocVo != null){
					List<DefdocDetailVO> list = defdocDetailService.getDefDocByDefId(customerTypedefdocVo.getId());
					if(list!=null&&list.size()>0){
						for(DefdocDetailVO vo : list){
							customerTypeMap.put(vo.getId(), vo.getName());
						}
					}
				}

				for(int i=0;i<result.size();i++) {
					ProjectVO projectVO = new ProjectVO();
					try{
						List<String> datas = result.get(i);
						if(StringUtils.isEmpty(datas.get(0))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：项目名称不能为空！");
							continue;
						}else{
							projectVO.setProjectName(datas.get(0));
						}
						projectVO.setProjectAliasName(datas.get(1));//项目别名
						projectVO.setProjectType("施工类");//项目类型

						if(StringUtils.isEmpty(datas.get(4))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：所属组织不能为空！");
							continue;
						}else{
							if(orgMap.get(datas.get(4))==null){
								CommonResponse<OrgVO> orgVO = iOrgApi.findByNameAndTenantId(datas.get(4), InvocationInfoProxy.getTenantid());
								if(orgVO.isSuccess()&&orgVO.getData()!=null){
									projectVO.setOrgId(orgVO.getData().getId());
									projectVO.setOrgName(datas.get(4));//所属组织(等同实施单位)
									projectVO.setBuild(orgVO.getData().getId());
									orgMap.put(datas.get(4), orgVO.getData().getId());
								}else{
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：所属组织未获取到！");
									continue;
								}
							}else{
								projectVO.setOrgId(orgMap.get(datas.get(4)));
								projectVO.setOrgName(datas.get(4));//所属组织(等同实施单位)
								projectVO.setBuild(orgMap.get(datas.get(4)));
							}
						}

						if(StringUtils.isEmpty(datas.get(5))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：发包人（建设单位）不能为空！");
							continue;
						}else{
							projectVO.setConstructionUnitName(datas.get(5));//发包人（建设单位）
							Map<String, Object> params = new HashMap<>();
							params.put("name", datas.get(5));
							params.put("tenantId", tenantId);

							String responseStr = HttpTookit.get(environmentTools.getBaseHost()+"ejc-share-web/api/shareCustomerApi/findOneByName", params, request);

							CommonResponse<JSONObject> customerlist = JSON.parseObject(responseStr, CommonResponse.class);
							if(customerlist.isSuccess()&&customerlist.getData()!=null){
								projectVO.setConstructionUnit(customerlist.getData().get("id")!=null?Long.parseLong(customerlist.getData().get("id").toString()): null);//发包人（建设单位）

								if(customerlist.getData().get("customerType")!=null&&customerTypeMap.get(customerlist.getData().get("customerType"))!=null){
									projectVO.setPromoterNature(Long.parseLong(customerlist.getData().get("customerType").toString())); // 发包人性质
									projectVO.setPromoterNatureName(customerTypeMap.get(customerlist.getData().get("customerType"))); // 发包人性质名称
								}
								projectVO.setPromoterSocialCreditCode(customerlist.getData().get("socialCreditCode")!=null?customerlist.getData().get("socialCreditCode").toString():null); // 统一社会信用代码
								projectVO.setPromoterAdress(customerlist.getData().get("area")!=null?customerlist.getData().get("area").toString():null); // 发包人地址
								projectVO.setPromoterLegal(customerlist.getData().get("legal")!=null?customerlist.getData().get("legal").toString():null); //  法人代表
								projectVO.setPromoterTelephone(customerlist.getData().get("telephone")!=null?customerlist.getData().get("telephone").toString():null); // 法人电话

//								projectVO.setConstructionUnit(customerlist.getData().get("id").getId());//发包人（建设单位）
//
//								projectVO.setPromoterNature(customerlist.getData().getCustomerType()); // 发包人性质
//								if(customerTypeMap.get(customerlist.getData().getCustomerType())!=null){
//									projectVO.setPromoterNatureName(customerTypeMap.get(customerlist.getData().getCustomerType())); // 发包人性质名称
//								}
//								projectVO.setPromoterSocialCreditCode(customerlist.getData().getSocialCreditCode()); // 统一社会信用代码
//								projectVO.setPromoterAdress(customerlist.getData().getArea()); // 发包人地址
//								projectVO.setPromoterLegal(customerlist.getData().getLegal()); //  法人代表
//								projectVO.setPromoterTelephone(customerlist.getData().getTelephone()); // 法人电话
							}else{
								errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：发包人（建设单位）未获取到！");
								continue;
							}
						}

						projectVO.setDesignUnit(datas.get(6));//设计单位
						projectVO.setSupervisionUnit(datas.get(7));//监理单位

						if(StringUtils.isNotEmpty(datas.get(8))){//承包模式
							projectVO.setContractualModelName(datas.get(8));//承包模式
							if(contractualModelMap.get(datas.get(8))!=null){
								projectVO.setContractualModel(contractualModelMap.get(datas.get(8)));//承包模式
							}
						}

						if(StringUtils.isNotEmpty(datas.get(9))){//投资来源
							projectVO.setInvestmentSourceName(datas.get(9));//投资来源
							if(investmentSourceMap.get(datas.get(9))!=null){
								projectVO.setInvestmentSource(investmentSourceMap.get(datas.get(9)));//投资来源
							}
						}

						if(StringUtils.isNotEmpty(datas.get(10))){//建筑类型
							projectVO.setTypeName(datas.get(10));//建筑类型
							if(typeMap.get(datas.get(10))!=null){
								projectVO.setType(typeMap.get(datas.get(10)));//建筑类型
							}
						}

						if(StringUtils.isNotEmpty(datas.get(11))){
							logger.info("开工日期：------------->"+datas.get(11));
							if(datas.get(11).contains("-")){
								projectVO.setStartDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(11)));//开工日期
							}else{
								projectVO.setStartDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(11)));//开工日期
							}
						}

						if(StringUtils.isNotEmpty(datas.get(12))){
							logger.info("竣工日期：------------->"+datas.get(12));
							if(datas.get(12).contains("-")){
								projectVO.setEndDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(12)));//竣工日期
							}else{
								projectVO.setEndDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(12)));//竣工日期
							}
						}

						if(StringUtils.isNotEmpty(datas.get(13))){
							logger.info("实际开工日期：------------->"+datas.get(13));
							if(datas.get(13).contains("-")){
								projectVO.setActualStartDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(13)));//实际开工日期
							}else{
								projectVO.setActualStartDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(13)));//实际开工日期
							}
						}

						if(StringUtils.isNotEmpty(datas.get(14))){
							logger.info("实际竣工日期：------------->"+datas.get(14));
							if(datas.get(14).contains("-")){
								projectVO.setActualEndDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(14)));//实际竣工日期
							}else{
								projectVO.setActualEndDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(14)));//实际竣工日期
							}
						}

						projectVO.setBaseType(datas.get(15));//基础类型
						projectVO.setStructureType(datas.get(16));//结构类型

//						projectVO.setBuiltArea(StringUtils.isNotBlank(datas.get(17))?new BigDecimal(datas.get(17)):null);//工程规模（平）(建筑面积)
						projectVO.setBuiltArea(datas.get(17));//工程规模（平）(建筑面积)
						projectVO.setBuiltHeight(StringUtils.isNotBlank(datas.get(18))?new BigDecimal(datas.get(18)):null);//建筑高度

						projectVO.setLayerNumber(datas.get(19));//层数(地上/地下)

						projectVO.setPrefabricationRate(StringUtils.isNotBlank(datas.get(20))?new BigDecimal(datas.get(20)):null);//预制率（%）
						projectVO.setAssemblyRate(StringUtils.isNotBlank(datas.get(21))?new BigDecimal(datas.get(21)):null);//装配率（%）

						projectVO.setEpcContractScope(datas.get(22)!=null?(datas.get(22).length()>200?datas.get(22).substring(0, 200):datas.get(22)):null);//总包合同范围
						projectVO.setSpecifySubcontractSscope(datas.get(23)!=null?(datas.get(23).length()>200?datas.get(23).substring(0, 200):datas.get(23)):null);//指定分包合同范围

						projectVO.setLeader(Long.parseLong(InvocationInfoProxy.getEmployeeId()));//项目负责人

						projectVO.setLeaderContactInformation(datas.get(25));//负责人联系方式
						projectVO.setDuration(StringUtils.isNotBlank(datas.get(26))?Integer.parseInt(datas.get(26)):null);//工期(天)

						if(StringUtils.isEmpty(datas.get(27))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：承包单位不能为空！");
							continue;
						}else{
							if(orgMap.get(datas.get(27))==null){
								CommonResponse<OrgVO> orgVO = iOrgApi.findByNameAndTenantId(datas.get(27), InvocationInfoProxy.getTenantid());
								if(orgVO.isSuccess()&&orgVO.getData()!=null){
									projectVO.setContractorUnit(orgVO.getData().getId());//承包单位
									orgMap.put(datas.get(27), orgVO.getData().getId());
								}else{
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：承包单位未获取到！");
									continue;
								}
							}else{
								projectVO.setContractorUnit(orgMap.get(datas.get(27)));//承包单位
							}
						}

						if(StringUtils.isNotEmpty(datas.get(28))){
							if(qualityAgreementMap.get(datas.get(28))!=null){//质量约定
								projectVO.setQualityAgreement(qualityAgreementMap.get(datas.get(28)));//质量约定
							}
						}

						projectVO.setProjectScale(datas.get(29));//工程规模（平）(建筑面积)
						projectVO.setPriceMethod(datas.get(30));//计价方式

						projectVO.setSelfConstructionContractAmount(StringUtils.isNotBlank(datas.get(31))?new BigDecimal(datas.get(31)):null);//自施合同额（元）

						projectVO.setProjectBiddingProfit(StringUtils.isNotBlank(datas.get(32))?new BigDecimal(datas.get(32)):null);//项目投标利润率（%）

						projectVO.setConsortiumWonBid(datas.get(33));//联合体中标
						projectVO.setInvestmentProject(datas.get(34));//融投资带动项目
						projectVO.setQuotaPriceDownwardRate(StringUtils.isNotBlank(datas.get(35))?new BigDecimal(datas.get(35)):null);//定额计价下浮率（%）

						if(StringUtils.isEmpty(datas.get(36))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：签约单位不能为空！");
							continue;
						}else{
							if(orgMap.get(datas.get(36))==null){
								CommonResponse<OrgVO> orgVO = iOrgApi.findByNameAndTenantId(datas.get(36), InvocationInfoProxy.getTenantid());
								if(orgVO.isSuccess()&&orgVO.getData()!=null){
									projectVO.setSignUnit(orgVO.getData().getId());//承包单位
									orgMap.put(datas.get(36), orgVO.getData().getId());
								}else{
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：签约单位未获取到！");
									continue;
								}
							}else{
								projectVO.setSignUnit(orgMap.get(datas.get(36)));//承包单位
							}
						}

						if(StringUtils.isNotEmpty(datas.get(37))){
							logger.info("签约日期：------------->"+datas.get(37));
							if(datas.get(37).contains("-")){
								projectVO.setSignDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(37)));//签约日期
							}else{
								projectVO.setSignDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(37)));//签约日期
							}
						}

						if(StringUtils.isNotEmpty(datas.get(38))){
							if(projectCategoryMap.get(datas.get(38))!=null){//项目类别
								projectVO.setProjectCategory(projectCategoryMap.get(datas.get(38)));//项目类别
							}
						}

						if(StringUtils.isNotEmpty(datas.get(39))){
							if(signStatusMap.get(datas.get(39))!=null){//签约状态
								projectVO.setSignStatus(signStatusMap.get(datas.get(39)));//签约状态
							}
						}

						if(StringUtils.isNotEmpty(datas.get(40))){
							if(biddingFormMap.get(datas.get(40))!=null){//招标形式
								projectVO.setBiddingForm(biddingFormMap.get(datas.get(40)));//招标形式
							}
						}

						if(StringUtils.isNotEmpty(datas.get(41))){
							logger.info("签约日期：------------->"+datas.get(41));
							if(datas.get(41).contains("-")){
								projectVO.setNotificationAwardDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(41)));//中标通知书日期
							}else{
								projectVO.setNotificationAwardDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(41)));//中标通知书日期
							}
						}

						//子表数据
						projectVO.setContractAmount(StringUtils.isNotBlank(datas.get(42))?new BigDecimal(datas.get(42)):null);//合同额（元）
						projectVO.setBelong(datas.get(44));
						//地址
						projectVO.setProjectLocation(datas.get(45));
						service.saveData(projectVO);
					}catch(Exception e){
						errorList.add("第"+i+"行数据：" + "导入失败，原因：" + e.getMessage());
						logger.error("导入异常-------------》{}",e);
					}

				}
			}
			if(errorList.size() > 0) {

				errorList.add("导入成功："+(result.size() - errorList.size() - 1)+"条, 失败：" +errorList.size()+"条");
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}
}
