package com.ejianc.foundation.share.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface MaterialMapper {

	List<MaterialEntity> queryListByCategoryId(@Param("tenantId") Long tenantId,@Param("categoryId") Long categoryId);

	List<MaterialEntity> queryList(Map<String, Object> condition);

	Long queryCount(Map<String, Object> condition);

	MaterialEntity queryDetail(@Param("tenantId") Long tenantId, @Param("id") Long id);

	void save(MaterialVO materialVo);

	void insertBatch(@Param("tenantId") Long tenantId,@Param("list") List<MaterialVO> list);

	void update(MaterialVO uniqueBean);

	void delete(@Param("tenantId") Long tenantId, @Param("id") Long id);

	MaterialVO queryExitFlag(@Param("tenantId") Long tenantId, @Param("name") String name,@Param("spec") String spec,@Param("unitName") String unitName,@Param("categoryId") Long categoryId);

	MaterialVO queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

	List<MaterialEntity> queryExportList(Map<String, Object> condition);

	void insertMaterialListFromPlatform(@Param("tenantId") Long tenantId);

	List<MaterialEntity> queryRefMaterialList(Map<String, Object> params);

	Long queryRefMaterialCount(Map<String, Object> params);

	MaterialEntity queryBySourceId(@Param("sourceId") String sourceId,@Param("tenantId") Long tenantId);

	List<MaterialEntity> queryMaterialByIds(@Param("ids") List<Long> ids, @Param("tenantId") Long tenantId);


	List<MaterialEntity> queryZjwjRefMaterialList(Map<String, Object> params);

	Long queryZjwjRefMaterialCount(Map<String, Object> params);

	List<MaterialEntity> queryMaterialListByNames(@Param("tenantId") Long tenantId, @Param("nameList") List<String> nameList);

	MaterialVO queryLastMaterialByTime(@Param("tenantId") Long tenantid);

	List<MaterialEntity> queryMaterialList(@Param("tenantId") Long tenantId, @Param("name") String name, @Param("spec") String spec, @Param("unitName") String unitName);

	/**
	 * like or 模糊匹配
	 *
	 * @param tenantId     租户id
	 * @param name         清单名称
	 * @param names        清单名称分词
	 * @param type         费用类型
	 * @param categoryName 分类名称
	 * @param spec         规范型号
	 * @param unitName     单位名称
	 *
	 * @return {@link List}<{@link MaterialPlusVO}>
	 */
	List<MaterialPlusVO> findFuzzyResultListByLikeOr(@Param(value = "tenantId") Long tenantId,
	                                                 @Param(value = "name") String name,
	                                                 @Param(value = "names") List<String> names,
	                                                 @Param(value = "type") Integer type,
	                                                 @Param(value = "categoryName") String categoryName,
	                                                 @Param(value = "spec") String spec,
	                                                 @Param(value = "unitName") String unitName);

	/**
	 * 模糊匹配分页查询
	 *
	 * @param page          分页参数
	 * @param tenantId      租户id
	 * @param name          清单名称
	 * @param names         清单名称分词
	 * @param type          费用类型
	 * @param categoryName  分类名称
	 * @param spec          规范型号
	 * @param unitName      单位名称
	 * @param fuzzyName     清单名称模糊
	 * @param fuzzySpec     规格型号模糊
	 * @param fuzzyUnitName 单位名称模糊
	 *
	 * @return {@link List}<{@link MaterialPlusVO}>
	 */
	List<MaterialPlusVO> fuzzyMatchQueryPage(Page<MaterialPlusVO> page,
	                                         @Param(value = "tenantId") Long tenantId,
	                                         @Param(value = "name") String name,
	                                         @Param(value = "names") List<String> names,
	                                         @Param(value = "type") Integer type,
	                                         @Param(value = "categoryName") String categoryName,
	                                         @Param(value = "spec") String spec,
	                                         @Param(value = "unitName") String unitName,
	                                         @Param(value = "fuzzyName") String fuzzyName,
	                                         @Param(value = "fuzzySpec") String fuzzySpec,
	                                         @Param(value = "fuzzyUnitName") String fuzzyUnitName);

	MaterialVO queryAllByTenantIdAndNameAndTypeAndSpecAndUnitName(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId, @Param("name") String name, @Param("type") Integer type, @Param("spec") String spec, @Param("unitName") String unitName);


	void insertBatch1(@Param("tenantId") Long tenantId, @Param("list") List<MaterialVO> list);

	List<MaterialEntity>  queryByCodes(@Param("tenantId") Long tenantId, @Param("codes") List<String> codes);

	void enableOrDisable(@Param("tenantId") Long tenantid, @Param("ids") List<Long> ids, @Param("innerCode") String innerCode, @Param("enabled") Integer enabled);

	List<MaterialEntity>  queryMaterialsToAi(@Param("tenantId") Long tenantId, @Param("size") Integer size);

	void updateMaterialsToAiState(@Param("tenantId") Long tenantId, @Param("ids") List<Long> ids);
}
